/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.validation.constraints;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.capella.filtering.validation.constraints.ConstraintsUtil;

public class MDCHK_D_Component_Functions
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL) {
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            if (eObj instanceof Component) {
                Component component = (Component)eObj;
                List componentFeatures = FilteringUtils.getAssociatedCriteria((EObject)component);
                for (AbstractFunction function : component.getAllocatedFunctions()) {
                    List functionFeatures = FilteringUtils.getAssociatedCriteria((EObject)function);
                    List<FilteringCriterion> missingFeatures = ConstraintsUtil.missingFilteringCriteria(functionFeatures, componentFeatures);
                    if (missingFeatures.isEmpty()) continue;
                    statuses.add(ctx.createFailureStatus(new Object[]{ConstraintsUtil.getNameForMessage((EObject)component), FilteringUtils.getCommaSeparatedFilteringCriteriaList(missingFeatures), ConstraintsUtil.getNameForMessage((EObject)function)}));
                }
            }
            if (!statuses.isEmpty()) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
            }
        }
        return ctx.createSuccessStatus();
    }
}

