/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.perfo.generic;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.vp.perfo.generic.IPerformanceBrowser;
import org.polarsys.capella.vp.perfo.perfo.PerformanceCapacity;
import org.polarsys.capella.vp.perfo.perfo.PerformanceConsumption;

public class GenericPerformanceService {
    public static GenericPerformanceService INSTANCE = new GenericPerformanceService();
    protected static IPerformanceBrowser _browser;

    protected void setBrowser(IPerformanceBrowser browser) {
        _browser = browser;
    }

    public IPerformanceBrowser getBrowser() {
        return _browser;
    }

    public int checkPerformance(EObject eObject) {
        int totalCns = this.getTotalCns(eObject);
        return totalCns;
    }

    private int getTotalCns(EObject eObject) {
        int cnsLeafs = this.getLeafsConsumption(eObject);
        int cnsSubComponent = this.subComponentsConsumption(eObject);
        return cnsLeafs + cnsSubComponent;
    }

    private int subComponentsConsumption(EObject eObject) {
        int totalLeafsCns = 0;
        EList<EObject> subComponentList = _browser.getSubComponentsObjects(eObject);
        if (subComponentList != null && subComponentList.size() > 0) {
            for (EObject subComponent : subComponentList) {
                totalLeafsCns += this.getTotalCns(subComponent);
            }
        }
        return totalLeafsCns;
    }

    private int getLeafsConsumption(EObject eObject) {
        int totalLeafsCns = 0;
        EList<EObject> leafs = _browser.getLeafsObjects(eObject);
        if (leafs != null && leafs.size() > 0) {
            for (EObject curLeaf : leafs) {
                totalLeafsCns += this.getLeafConsumptionValue(curLeaf);
            }
        }
        return totalLeafsCns;
    }

    private int getObjectCapacityValue(EObject thePart) {
        for (EObject curObjectChild : thePart.eContents()) {
            if (!(curObjectChild instanceof PerformanceCapacity)) continue;
            return ((PerformanceCapacity)curObjectChild).getValue();
        }
        return 0;
    }

    private int getLeafConsumptionValue(EObject curLeaf) {
        for (EObject curLeafChild : curLeaf.eContents()) {
            if (!(curLeafChild instanceof PerformanceConsumption)) continue;
            return ((PerformanceConsumption)curLeafChild).getValue();
        }
        return 0;
    }
}

