/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.util.object.MoreObjects;
import org.eclipse.buildship.core.workspace.internal.StringSetPersistentProperty;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;

final class ResourceFilter {
    private static final String FILTER_ID = "org.eclipse.ui.ide.multiFilter";
    private static final QualifiedName RESOURCE_PROPERTY_GRADLE_FILTER = new QualifiedName("org.eclipse.buildship.core", "GRADLE_FILTER");

    private ResourceFilter() {
    }

    public static void attachFilters(IProject project, List<File> childLocations, IProgressMonitor monitor) {
        monitor = (IProgressMonitor)MoreObjects.firstNonNull(monitor, new NullProgressMonitor());
        List<FileInfoMatcherDescription> matchers = ResourceFilter.createMatchers(project, childLocations);
        ResourceFilter.setExclusionFilters(project, matchers, monitor);
    }

    public static void detachAllFilters(IProject project, IProgressMonitor monitor) {
        monitor = (IProgressMonitor)MoreObjects.firstNonNull(monitor, new NullProgressMonitor());
        monitor.beginTask(String.format("Remove Gradle resource filters from project %s", project), -1);
        try {
            StringSetPersistentProperty knownMatcherNames = StringSetPersistentProperty.from(RESOURCE_PROPERTY_GRADLE_FILTER, (IResource)project);
            Set<String> matcherNames = knownMatcherNames.get();
            for (IResourceFilterDescription filter : project.getFilters()) {
                FileInfoMatcherDescription matcher = filter.getFileInfoMatcherDescription();
                if (matcher == null || !(matcher.getArguments() instanceof String) || !matcherNames.contains(matcher.getArguments())) continue;
                knownMatcherNames.remove((String)matcher.getArguments());
                filter.delete(128, monitor);
            }
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException((Exception)((Object)e));
        }
        finally {
            monitor.done();
        }
    }

    static List<FileInfoMatcherDescription> createMatchers(IProject project, List<File> children) {
        ImmutableList.Builder matchers = ImmutableList.builder();
        IPath projectLocation = project.getLocation();
        for (File child : children) {
            Path childLocation = new Path(child.getAbsolutePath());
            if (!projectLocation.isPrefixOf((IPath)childLocation)) continue;
            matchers.add((Object)new FileInfoMatcherDescription(FILTER_ID, (Object)ResourceFilter.createMultiFilterArgument(childLocation.makeRelativeTo(projectLocation).toPortableString())));
        }
        return matchers.build();
    }

    private static String createMultiFilterArgument(String relativeLocation) {
        return "1.0-projectRelativePath-matches-false-false-" + relativeLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setExclusionFilters(IProject project, List<FileInfoMatcherDescription> matchers, IProgressMonitor monitor) {
        block8: {
            monitor.beginTask(String.format("Set Gradle resource filters for project %s", project), -1);
            try {
                IResourceFilterDescription[] existingFilters;
                try {
                    existingFilters = project.getFilters();
                }
                catch (CoreException e) {
                    String message = String.format("Cannot retrieve current resource filters for project %s.", project.getName());
                    throw new GradlePluginsRuntimeException(message, (Exception)((Object)e));
                }
                ImmutableList newMatchers = FluentIterable.from(matchers).filter((Predicate)new Predicate<FileInfoMatcherDescription>(){

                    public boolean apply(FileInfoMatcherDescription matcher) {
                        for (IResourceFilterDescription existingFilter : existingFilters) {
                            if (!existingFilter.getFileInfoMatcherDescription().equals((Object)matcher)) continue;
                            return false;
                        }
                        return true;
                    }
                }).toList();
                if (matchers.isEmpty()) break block8;
                try {
                    int type = 26;
                    for (FileInfoMatcherDescription matcher : newMatchers) {
                        project.createFilter(type, matcher, 128, (IProgressMonitor)new NullProgressMonitor());
                        StringSetPersistentProperty.from(RESOURCE_PROPERTY_GRADLE_FILTER, (IResource)project).add((String)matcher.getArguments());
                    }
                }
                catch (CoreException e) {
                    String message = String.format("Cannot create new resource filters for project %s.", project);
                    throw new GradlePluginsRuntimeException(message, (Exception)((Object)e));
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

