/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.scope;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.help.ICriteria;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.base.util.CriteriaUtilities;
import org.eclipse.help.internal.criteria.CriteriaProviderRegistry;
import org.eclipse.help.internal.criteria.CriterionResource;

public class CriteriaHelpScope
extends AbstractHelpScope {
    private static final String UNCATEGORIZED = "Uncategorized";
    private CriterionResource[] criteriaScope;

    public CriteriaHelpScope(CriterionResource[] criteriaScope) {
        this.criteriaScope = criteriaScope;
    }

    public CriteriaHelpScope(List criteriaScope) {
        if (criteriaScope == null) {
            this.criteriaScope = new CriterionResource[0];
        } else {
            this.criteriaScope = new CriterionResource[criteriaScope.size()];
            criteriaScope.toArray(this.criteriaScope);
        }
    }

    public boolean inScope(IToc toc) {
        if (toc == null) {
            return this.criteriaScope == null || this.criteriaScope.length == 0;
        }
        ICriteria[] criteriaOfToc = CriteriaProviderRegistry.getInstance().getAllCriteria(toc);
        return this.isCriteriaInScope(criteriaOfToc);
    }

    public boolean inScope(ITopic topic) {
        if (topic == null) {
            return this.criteriaScope == null || this.criteriaScope.length == 0;
        }
        ICriteria[] criteriaOfTopic = CriteriaProviderRegistry.getInstance().getAllCriteria(topic);
        return this.isCriteriaInScope(criteriaOfTopic);
    }

    private boolean isCriteriaInScope(ICriteria[] criteriaOfTopic) {
        if (this.criteriaScope == null) {
            return true;
        }
        Map ownCriteria = this.getCriteriaInfo(criteriaOfTopic);
        Map scope = this.getCriteriaInfo(this.criteriaScope);
        Iterator keyIterator = scope.keySet().iterator();
        block0: while (keyIterator.hasNext()) {
            String key = String.valueOf(keyIterator.next());
            Iterator valueIterator = ((Set)scope.get(key)).iterator();
            while (valueIterator.hasNext()) {
                String value = String.valueOf(valueIterator.next());
                if (!value.equals(UNCATEGORIZED) ? ownCriteria.get(key) != null && ((Set)ownCriteria.get(key)).contains(value) : !ownCriteria.containsKey(key)) continue block0;
            }
            return false;
        }
        return true;
    }

    private Map getCriteriaInfo(CriterionResource[] criteria) {
        HashMap criteriaMap = new HashMap();
        CriteriaUtilities.addCriteriaToMap(criteriaMap, criteria);
        return criteriaMap;
    }

    private Map getCriteriaInfo(ICriteria[] criteria) {
        HashMap criteriaMap = new HashMap();
        CriteriaUtilities.addCriteriaToMap(criteriaMap, criteria);
        return criteriaMap;
    }

    public boolean inScope(IIndexEntry entry) {
        return this.hasInScopeChildren((IUAElement)entry);
    }

    public String getName(Locale locale) {
        return null;
    }
}

