/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ide.ui.services;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ide.ui.dialog.AbstractPromptDialog;
import org.eclipse.acceleo.query.ide.ui.dialog.EObjectSelectionDialog;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.AbstractServiceProvider;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.swt.widgets.Display;

@ServiceProvider(value="Services available for prompting user for values using SWT for graphical user interface.")
public class SWTPromptServices
extends AbstractServiceProvider {
    private static final String M2DOC_DIALOG_CANCELLED = "M2Doc dialog cancelled.";
    private final ResourceSet resourceSetForModels;
    private final IReadOnlyQueryEnvironment queryEnvironment;
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public SWTPromptServices(IReadOnlyQueryEnvironment queryEnvironment, ResourceSet resourceSetForModels) {
        this.resourceSetForModels = resourceSetForModels;
        this.queryEnvironment = queryEnvironment;
    }

    @Documentation(value="Prompts for a String value with the given message.", params={@Param(name="message", value="The message displayed to the user")}, result="Prompts the user and return the input of the user as a String.", examples={@Example(expression="'Enter your name: '.promptString()", result="prompts the user")})
    public String promptString(final String message) {
        RunnableWithResult<String> runnable = new RunnableWithResult<String>(){

            @Override
            public void run() {
                AbstractPromptDialog dialog = new AbstractPromptDialog(Display.getDefault().getActiveShell(), message){

                    @Override
                    public boolean validate(String input) {
                        return input != null;
                    }
                };
                this.result = dialog.open() == 0 ? dialog.getValue() : null;
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        if (runnable.getResult() != null) {
            return (String)runnable.getResult();
        }
        throw new IllegalStateException(M2DOC_DIALOG_CANCELLED);
    }

    @Documentation(value="Prompts for a Integer value with the given message.", params={@Param(name="message", value="The message displayed to the user")}, result="Prompts the user and return the input of the user as an Integer.", examples={@Example(expression="'Enter your age: '.promptInteger()", result="prompts the user")})
    public Integer promptInteger(final String message) {
        RunnableWithResult<Integer> runnable = new RunnableWithResult<Integer>(){

            @Override
            public void run() {
                AbstractPromptDialog dialog = new AbstractPromptDialog(Display.getDefault().getActiveShell(), message){

                    @Override
                    public boolean validate(String input) {
                        return SWTPromptServices.this.validateInteger(input);
                    }
                };
                this.result = dialog.open() == 0 ? Integer.valueOf(dialog.getValue()) : null;
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        if (runnable.getResult() != null) {
            return (Integer)runnable.getResult();
        }
        throw new IllegalStateException(M2DOC_DIALOG_CANCELLED);
    }

    private boolean validateInteger(String input) {
        boolean res;
        try {
            Integer.valueOf(input);
            res = true;
        }
        catch (Exception e) {
            res = false;
        }
        return res;
    }

    @Documentation(value="Prompts for a Long value with the given message.", params={@Param(name="message", value="The message displayed to the user")}, result="Prompts the user and return the input of the user as an Long.", examples={@Example(expression="'Enter your age: '.promptLong()", result="prompts the user")})
    public Long promptLong(final String message) {
        RunnableWithResult<Long> runnable = new RunnableWithResult<Long>(){

            @Override
            public void run() {
                AbstractPromptDialog dialog = new AbstractPromptDialog(Display.getDefault().getActiveShell(), message){

                    @Override
                    public boolean validate(String input) {
                        return SWTPromptServices.this.validateLong(input);
                    }
                };
                this.result = dialog.open() == 0 ? Long.valueOf(dialog.getValue()) : null;
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        if (runnable.getResult() != null) {
            return (Long)runnable.getResult();
        }
        throw new IllegalStateException(M2DOC_DIALOG_CANCELLED);
    }

    private boolean validateLong(String input) {
        boolean res;
        try {
            Long.valueOf(input);
            res = true;
        }
        catch (Exception e) {
            res = false;
        }
        return res;
    }

    @Documentation(value="Prompts for a Float value with the given message.", params={@Param(name="message", value="The message displayed to the user")}, result="Prompts the user and return the input of the user as a Float.", examples={@Example(expression="'Enter your weight: '.promptFloat()", result="prompts the user")})
    public Float promptFloat(final String message) {
        RunnableWithResult<Float> runnable = new RunnableWithResult<Float>(){

            @Override
            public void run() {
                AbstractPromptDialog dialog = new AbstractPromptDialog(Display.getDefault().getActiveShell(), message){

                    @Override
                    public boolean validate(String input) {
                        return SWTPromptServices.this.validateFloat(input);
                    }
                };
                this.result = dialog.open() == 0 ? Float.valueOf(dialog.getValue()) : null;
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        if (runnable.getResult() != null) {
            return (Float)runnable.getResult();
        }
        throw new IllegalStateException(M2DOC_DIALOG_CANCELLED);
    }

    private boolean validateFloat(String input) {
        boolean res;
        try {
            Float.valueOf(input);
            res = true;
        }
        catch (Exception e) {
            res = false;
        }
        return res;
    }

    @Documentation(value="Prompts for a Double value with the given message.", params={@Param(name="message", value="The message displayed to the user")}, result="Prompts the user and return the input of the user as a Double.", examples={@Example(expression="'Enter your weight: '.promptDouble()", result="prompts the user")})
    public Double promptDouble(final String message) {
        RunnableWithResult<Double> runnable = new RunnableWithResult<Double>(){

            @Override
            public void run() {
                AbstractPromptDialog dialog = new AbstractPromptDialog(Display.getDefault().getActiveShell(), message){

                    @Override
                    public boolean validate(String input) {
                        return SWTPromptServices.this.validateDouble(input);
                    }
                };
                this.result = dialog.open() == 0 ? Double.valueOf(dialog.getValue()) : null;
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        if (runnable.getResult() != null) {
            return (Double)runnable.getResult();
        }
        throw new IllegalStateException(M2DOC_DIALOG_CANCELLED);
    }

    private boolean validateDouble(String input) {
        boolean res;
        try {
            Double.valueOf(input);
            res = true;
        }
        catch (Exception e) {
            res = false;
        }
        return res;
    }

    public EObject promptEObject(String message, EClass eCls) {
        HashSet<EClass> acceptedEClasses = new HashSet<EClass>();
        acceptedEClasses.add(eCls);
        return this.promptEObject(message, acceptedEClasses);
    }

    public EObject promptEObject(final String message, final Set<EClass> acceptedEClasses) {
        RunnableWithResult<EObject> runnable = new RunnableWithResult<EObject>(){

            @Override
            public void run() {
                EObjectSelectionDialog dialog = new EObjectSelectionDialog(Display.getDefault().getActiveShell(), (AdapterFactory)SWTPromptServices.this.adapterFactory, "M2Doc", message, SWTPromptServices.this.queryEnvironment, SWTPromptServices.this.resourceSetForModels, acceptedEClasses);
                this.result = dialog.open() == 0 ? (EObject)dialog.getValue() : null;
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        if (runnable.getResult() != null) {
            return (EObject)runnable.getResult();
        }
        throw new IllegalStateException(M2DOC_DIALOG_CANCELLED);
    }

    public void dispose() {
        this.adapterFactory.dispose();
    }

    protected IService<Method> getService(Method method, boolean forWorkspace) {
        Object result = "promptEObject".equals(method.getName()) ? new EOBjectPromptService(method, (Object)this, forWorkspace) : (!"dispose".equals(method.getName()) ? new JavaMethodService(method, (Object)this, forWorkspace) : null);
        return result;
    }

    private static class EOBjectPromptService
    extends JavaMethodService {
        EOBjectPromptService(Method publicMethod, Object serviceInstance, boolean forWorkspace) {
            super(publicMethod, serviceInstance, forWorkspace);
        }

        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment environment, List<IType> argTypes) {
            return new LinkedHashSet<IType>(argTypes);
        }

        public Set<IType> validateAllType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, Map<List<IType>, Set<IType>> allTypes) {
            LinkedHashSet<IType> res = new LinkedHashSet<IType>();
            for (Set<IType> types : allTypes.values()) {
                res.addAll(types);
            }
            return res;
        }
    }

    private static abstract class RunnableWithResult<T>
    implements Runnable {
        protected T result;

        private RunnableWithResult() {
        }

        public T getResult() {
            return this.result;
        }
    }
}

