/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.interpreter;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.common.tools.Messages;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterProvider;
import org.eclipse.sirius.common.tools.api.interpreter.InterpreterStatusFactory;
import org.eclipse.sirius.common.tools.api.interpreter.TypeName;
import org.eclipse.sirius.common.tools.api.interpreter.ValidationResult;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.common.tools.internal.interpreter.AbstractInterpreter;

public class FeatureInterpreter
extends AbstractInterpreter
implements IInterpreter,
IInterpreterProvider {
    public static final String PREFIX = "feature:";
    public static final String E_CONTAINER_FEATURE_NAME = "eContainer";
    public static final String E_CONTENTS_FEATURE_NAME = "eContents";
    public static final String E_ALL_CONTENTS_FEATURE_NAME = "eAllContents";
    public static final String E_CLASS_FEATURE_NAME = "eClass";
    public static final String E_CROSS_REFERENCES_FEATURE_NAME = "eCrossReferences";
    public static final String[] DEFAULT_FEATURE_NAMES = new String[]{"eContainer", "eContents", "eAllContents", "eClass", "eCrossReferences"};

    @Override
    public IInterpreter createInterpreter() {
        return new FeatureInterpreter();
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public Object evaluate(EObject target, String expression) throws EvaluationException {
        Object result = null;
        if (target != null && expression != null && expression.startsWith(PREFIX)) {
            String featureName = expression.trim().substring(PREFIX.length());
            EClass targetEClass = target.eClass();
            EStructuralFeature feature = targetEClass.getEStructuralFeature(featureName);
            if (feature != null) {
                result = target.eGet(feature);
            } else if (E_CONTAINER_FEATURE_NAME.equals(featureName)) {
                result = target.eContainer();
            } else if (E_CONTENTS_FEATURE_NAME.equals(featureName)) {
                result = target.eContents();
            } else if (E_ALL_CONTENTS_FEATURE_NAME.equals(featureName)) {
                result = Lists.newArrayList((Iterator)target.eAllContents());
            } else if (E_CLASS_FEATURE_NAME.equals(featureName)) {
                result = targetEClass;
            } else if (E_CROSS_REFERENCES_FEATURE_NAME.equals(featureName)) {
                result = target.eCrossReferences();
            } else {
                throw new EvaluationException(MessageFormat.format(Messages.FeatureInterpreter_unknownFeature, featureName));
            }
        }
        return result;
    }

    @Override
    public boolean supportsValidation() {
        return true;
    }

    @Override
    public ValidationResult analyzeExpression(IInterpreterContext context, String expression) {
        ValidationResult interpreterStatus = new ValidationResult();
        if (expression != null && context != null && expression.startsWith(PREFIX)) {
            String featureName = expression.substring(PREFIX.length());
            VariableType targetType = context.getTargetType();
            if (!this.isDefaultFeatureName(featureName)) {
                LinkedHashSet<EClassifier> possibleReturnTypes = new LinkedHashSet<EClassifier>();
                for (TypeName typeName : targetType.getPossibleTypes()) {
                    UnmodifiableIterator possibleEClasses = Iterators.filter(typeName.search(context.getAvailableEPackages()).iterator(), EClass.class);
                    boolean foundAtLeastOneValid = false;
                    while (!foundAtLeastOneValid && possibleEClasses.hasNext()) {
                        EClass cur = (EClass)possibleEClasses.next();
                        foundAtLeastOneValid = this.hasFeatureNameAndCollectReturnTypes(cur, featureName, possibleReturnTypes);
                    }
                    if (foundAtLeastOneValid) continue;
                    interpreterStatus.addStatus(InterpreterStatusFactory.createInterpreterStatus(context, "error", MessageFormat.format(Messages.FeatureInterpreter_invalidFeature, typeName.getCompleteName("::"), featureName)));
                }
                if (!possibleReturnTypes.isEmpty()) {
                    interpreterStatus.setReturnType(VariableType.fromEClassifiers(possibleReturnTypes));
                }
            }
        }
        return interpreterStatus;
    }

    private boolean hasFeatureNameAndCollectReturnTypes(EClass currentElementType, String featureName, Set<EClassifier> possibleTargetTypes) {
        EStructuralFeature feature = currentElementType.getEStructuralFeature(featureName);
        if (feature instanceof EReference && feature.getEType() != null) {
            possibleTargetTypes.add(feature.getEType());
        }
        return feature != null;
    }

    private boolean isDefaultFeatureName(String featureName) {
        boolean isDefaultFeatureName = false;
        String[] stringArray = DEFAULT_FEATURE_NAMES;
        int n = DEFAULT_FEATURE_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultFeatureName = stringArray[n2];
            if (defaultFeatureName.equals(featureName)) {
                isDefaultFeatureName = true;
                break;
            }
            ++n2;
        }
        return isDefaultFeatureName;
    }
}

