/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.editor;

import org.eclipse.core.resources.IProject;
import org.eclipse.fordiac.ide.gef.utilities.TemplateCreationFactory;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.typelibrary.DeviceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SegmentTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.requests.CreationFactory;

public class SysConfTemplateTransferDropTargetListener
extends TemplateTransferDropTargetListener {
    private final IProject targetProject;

    public SysConfTemplateTransferDropTargetListener(EditPartViewer viewer, AutomationSystem system) {
        super(viewer);
        this.targetProject = system != null ? system.getTypeLibrary().getProject() : null;
    }

    protected void handleDragOver() {
        super.handleDragOver();
        this.getCurrentEvent().feedback = 24;
        if (TemplateTransfer.getInstance().getTemplate() == null) {
            this.getCurrentEvent().detail = 0;
            this.getCurrentEvent().operations = 0;
        } else if (TemplateTransfer.getInstance().getTemplate() instanceof TypeEntry) {
            TypeEntry entry = (TypeEntry)TemplateTransfer.getInstance().getTemplate();
            IProject srcProject = entry.getFile().getProject();
            if (SysConfTemplateTransferDropTargetListener.isSysConfEditorType(TemplateTransfer.getInstance().getTemplate()) && this.targetProject != null && this.targetProject.equals((Object)srcProject)) {
                this.getCurrentEvent().detail = 1;
            } else {
                this.getCurrentEvent().detail = 0;
                this.getCurrentEvent().operations = 0;
            }
        }
    }

    protected void handleDrop() {
        if (!SysConfTemplateTransferDropTargetListener.isSysConfEditorType(this.getCurrentEvent().data) && !(this.getCurrentEvent().data instanceof TemplateCreationFactory)) {
            return;
        }
        super.handleDrop();
        TemplateTransfer.getInstance().setTemplate(null);
    }

    protected CreationFactory getFactory(Object template) {
        this.getCurrentEvent().detail = 1;
        if (SysConfTemplateTransferDropTargetListener.isSysConfEditorType(template)) {
            return new SysConfTemplateCreationFactory(template);
        }
        if (template instanceof TemplateCreationFactory) {
            return super.getFactory(template);
        }
        FordiacLogHelper.logError((String)("Type not in list: " + template.getClass().getName()));
        return null;
    }

    private static boolean isSysConfEditorType(Object template) {
        return template instanceof DeviceTypeEntry || template instanceof ResourceTypeEntry || template instanceof SegmentTypeEntry;
    }

    private static class SysConfTemplateCreationFactory
    implements CreationFactory {
        private final Object typeTemplate;

        public SysConfTemplateCreationFactory(Object typeTemplate) {
            this.typeTemplate = typeTemplate;
        }

        public Object getNewObject() {
            return null;
        }

        public Object getObjectType() {
            return this.typeTemplate;
        }
    }
}

