/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.contentassist;

import java.util.Collections;
import java.util.List;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class STCoreConfigurableCompletionProposal
extends ConfigurableCompletionProposal {
    private boolean customLinkedMode;
    private ITextViewer viewer;
    private List<ITextRegion> positions = Collections.emptyList();
    private int exitPositionOffset = 0;
    private char[] exitChars;

    public STCoreConfigurableCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, StyledString displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
    }

    public void setCustomLinkedMode(ITextViewer viewer, List<ITextRegion> positions, int exitPositionOffset, char ... exitChars) {
        this.setSimpleLinkedMode(viewer, exitChars);
        this.customLinkedMode = true;
        this.viewer = viewer;
        this.positions = positions;
        this.exitPositionOffset = exitPositionOffset;
        this.exitChars = exitChars;
    }

    protected void setUpLinkedMode(IDocument document) {
        if (this.customLinkedMode) {
            try {
                LinkedModeModel model = new LinkedModeModel();
                for (ITextRegion position : this.positions) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, position.getOffset(), position.getLength()));
                    model.addGroup(group);
                }
                model.forceInstall();
                LinkedModeUI ui = new LinkedModeUI(model, this.viewer);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ConfigurableCompletionProposal.ExitPolicy(this.exitChars));
                ui.setExitPosition(this.viewer, this.exitPositionOffset, 0, Integer.MAX_VALUE);
                ui.enter();
            }
            catch (BadLocationException e) {
                FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
            }
        } else {
            super.setUpLinkedMode(document);
        }
    }

    public void shiftOffset(int deltaLength) {
        super.shiftOffset(deltaLength);
        this.positions = this.positions.stream().map(region -> new TextRegion(region.getOffset() + deltaLength, region.getLength())).toList();
        this.exitPositionOffset += deltaLength;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

