/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.preferences;

import org.eclipse.fordiac.ide.model.ui.Messages;
import org.eclipse.fordiac.ide.ui.preferences.FordiacPropertyPreferencePage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;

public class BlockSizePreferencePage
extends FordiacPropertyPreferencePage {
    private boolean changesOnLabelSize = false;

    public BlockSizePreferencePage() {
        super(1, "org.eclipse.fordiac.ide.model");
    }

    protected String getPreferencePageID() {
        return "org.eclipse.fordiac.ide.model.ui.preferences.BlockSizePreferences";
    }

    protected String getPropertyPageID() {
        return "org.eclipse.fordiac.ide.model.ui.properties.BlockSizePreferences";
    }

    protected void createFieldEditors() {
        this.createGroupBlockMargins();
        this.createGroupLabelSize();
    }

    private void createGroupBlockMargins() {
        Group blockMargin = new Group(this.getFieldEditorParent(), 0);
        blockMargin.setText(Messages.BlockSizePreferences_BlockMargins);
        IntegerFieldEditor integerFieldEditorTopBottom = new IntegerFieldEditor("MarginTopBottom", Messages.BlockSizePreferences_TopBottom, (Composite)blockMargin);
        integerFieldEditorTopBottom.setValidRange(0, 1000);
        this.addField((FieldEditor)integerFieldEditorTopBottom);
        IntegerFieldEditor integerFieldEditorLeftRight = new IntegerFieldEditor("MarginLeftRight", Messages.BlockSizePreferences_LeftRight, (Composite)blockMargin);
        integerFieldEditorLeftRight.setValidRange(0, 1000);
        this.addField((FieldEditor)integerFieldEditorLeftRight);
        BlockSizePreferencePage.configGroup(blockMargin);
    }

    private void createGroupLabelSize() {
        Group labelSize = new Group(this.getFieldEditorParent(), 0);
        labelSize.setText(Messages.BlockSizePreferences_LabelSize);
        IntegerFieldEditor integerFieldEditorLabel = new IntegerFieldEditor("MaxValueLabelSize", Messages.BlockSizePreferences_MaximumValueLabelSize, (Composite)labelSize);
        integerFieldEditorLabel.setValidRange(0, 120);
        this.addField((FieldEditor)integerFieldEditorLabel);
        IntegerFieldEditor integerFieldEditorTypeLabel = new IntegerFieldEditor("MaxTypeLabelSize", Messages.BlockSizePreferences_MaximumTypeLabelSize, (Composite)labelSize);
        integerFieldEditorTypeLabel.setValidRange(0, 120);
        this.addField((FieldEditor)integerFieldEditorTypeLabel);
        IntegerFieldEditor integerFieldEditorMinPin = new IntegerFieldEditor("MinPinLabelSize", Messages.BlockSizePreferences_MinimumPinLabelSize, (Composite)labelSize);
        integerFieldEditorMinPin.setValidRange(0, 60);
        this.addField((FieldEditor)integerFieldEditorMinPin);
        IntegerFieldEditor integerFieldEditorMaxPin = new IntegerFieldEditor("MaxPinLabelSize", Messages.BlockSizePreferences_MaximumPinLabelSize, (Composite)labelSize);
        integerFieldEditorMaxPin.setValidRange(0, 60);
        this.addField((FieldEditor)integerFieldEditorMaxPin);
        IntegerFieldEditor integerFieldEditorMinInterfaceBarWidth = new IntegerFieldEditor("MinInterfaceBarSize", Messages.BlockSizePreferences_MinimumInterfaceBarSize, (Composite)labelSize);
        integerFieldEditorMinInterfaceBarWidth.setValidRange(0, 100);
        this.addField((FieldEditor)integerFieldEditorMinInterfaceBarWidth);
        IntegerFieldEditor integerFieldEditorInterfaceBar = new IntegerFieldEditor("MaxInterfaceBarSize", Messages.BlockSizePreferences_MaximumInterfaceBarSize, (Composite)labelSize);
        integerFieldEditorInterfaceBar.setValidRange(0, 100);
        this.addField((FieldEditor)integerFieldEditorInterfaceBar);
        IntegerFieldEditor integerFieldEditorConnection = new IntegerFieldEditor("MaxHiddenConnectionLabelSize", Messages.BlockSizePreferences_MaximumHiddenConnectionLabelSize, (Composite)labelSize);
        integerFieldEditorConnection.setValidRange(0, 100);
        this.addField((FieldEditor)integerFieldEditorConnection);
        BlockSizePreferencePage.configGroup(labelSize);
    }

    private static void configGroup(Group group) {
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof FieldEditor && BlockSizePreferencePage.matchPreferenceName(event)) {
            this.changesOnLabelSize = true;
        }
    }

    private static boolean matchPreferenceName(PropertyChangeEvent event) {
        String sourcePrefName = ((FieldEditor)event.getSource()).getPreferenceName();
        return sourcePrefName.equalsIgnoreCase("MinPinLabelSize") || sourcePrefName.equalsIgnoreCase("MaxPinLabelSize") || sourcePrefName.equalsIgnoreCase("MaxTypeLabelSize") || sourcePrefName.equalsIgnoreCase("MaxValueLabelSize") || sourcePrefName.equalsIgnoreCase("MaxHiddenConnectionLabelSize") || sourcePrefName.equalsIgnoreCase("MaxInterfaceBarSize") || sourcePrefName.equalsIgnoreCase("MinInterfaceBarSize");
    }

    public boolean performOk() {
        super.performOk();
        if (this.changesOnLabelSize) {
            this.changesOnLabelSize = false;
            BlockSizePreferencePage.showMessageBox();
        }
        return true;
    }

    private static void showMessageBox() {
        MessageBox msgBox = new MessageBox(Display.getDefault().getActiveShell(), 32);
        Display.getDefault().getActiveShell();
        msgBox.setText("4diac IDE");
        msgBox.setMessage(Messages.BlockSizePreferences_Refresh);
        msgBox.open();
    }
}

