/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public final class HandlerHelper {
    private HandlerHelper() {
    }

    public static GraphicalViewer getViewer(IEditorPart editor) {
        return (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
    }

    public static CommandStack getCommandStack(IEditorPart editor) {
        return (CommandStack)editor.getAdapter(CommandStack.class);
    }

    public static FBNetwork getFBNetwork(IEditorPart editor) {
        return (FBNetwork)editor.getAdapter(FBNetwork.class);
    }

    public static boolean selectElement(Object element, IEditorPart editor) {
        GraphicalViewer viewer;
        if (editor != null && (viewer = HandlerHelper.getViewer(editor)) != null) {
            return HandlerHelper.selectElement(element, viewer);
        }
        return false;
    }

    public static boolean selectElement(Object element, GraphicalViewer viewer) {
        EditPart editPart;
        if (viewer != null && (editPart = viewer.getEditPartForModel(element)) != null) {
            HandlerHelper.selectEditPart((EditPartViewer)viewer, editPart);
            return true;
        }
        return false;
    }

    public static void selectEditPart(EditPartViewer viewer, EditPart editPart) {
        viewer.flush();
        if (viewer instanceof AdvancedScrollingGraphicalViewer) {
            AdvancedScrollingGraphicalViewer asgv = (AdvancedScrollingGraphicalViewer)viewer;
            asgv.selectAndRevealEditPart(editPart);
        } else {
            viewer.select(editPart);
            viewer.reveal(editPart);
        }
    }

    public static IEditorPart openEditor(EObject model) {
        return OpenListenerManager.openEditor(model);
    }

    public static IEditorPart openParentEditor(FBNetworkElement model) {
        EObject parentModel = model.eContainer().eContainer();
        return OpenListenerManager.openEditor(parentModel);
    }

    public static boolean isEditableSubApp(SubApp subApp) {
        if (subApp == null || subApp.isTyped()) {
            return false;
        }
        SubApp obj = subApp;
        while (obj.eContainer() != null) {
            if (!((obj = obj.eContainer()) instanceof TypedSubApp)) continue;
            return false;
        }
        return true;
    }

    public static List<FBNetworkElement> getSelectedFBNElements(ISelection selection) {
        IStructuredSelection sel;
        if (selection instanceof IStructuredSelection && !(sel = (IStructuredSelection)selection).isEmpty()) {
            return sel.toList().stream().filter(EditPart.class::isInstance).map(EditPart.class::cast).map(EditPart::getModel).filter(FBNetworkElement.class::isInstance).map(FBNetworkElement.class::cast).toList();
        }
        return Collections.emptyList();
    }

    public static void showExpandedSubapp(SubApp subapp, IEditorPart editor) {
        Display.getCurrent().asyncExec(() -> {
            ScalableFreeformRootEditPart gep;
            IFigure iFigure;
            RootEditPart rootEditPart;
            EditPart subappEP;
            GraphicalViewer viewer = HandlerHelper.getViewer(editor);
            if (viewer != null && (subappEP = viewer.getEditPartForModel((Object)subapp)) != null && (rootEditPart = subappEP.getRoot()) instanceof ScalableFreeformRootEditPart && (iFigure = (gep = (ScalableFreeformRootEditPart)rootEditPart).getFigure()) instanceof FreeformViewport) {
                FreeformViewport viewp = (FreeformViewport)iFigure;
                Point pos = subapp.getPosition().toScreenPoint();
                viewp.setHorizontalLocation((int)((double)pos.x * gep.getZoomManager().getZoom()));
                viewp.setVerticalLocation((int)((double)pos.y * gep.getZoomManager().getZoom()));
            }
        });
    }
}

