/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;

public abstract class AbstractLaunchProcess
extends PlatformObject
implements IProcess {
    protected final String name;
    protected final ILaunch launch;
    private final Map<String, String> attributes = new HashMap<String, String>();

    protected AbstractLaunchProcess(String name, ILaunch launch) {
        this.name = name;
        this.launch = launch;
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    protected void fireChangeEvent() {
        this.fireEvent(new DebugEvent((Object)this, 16));
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(IProcess.class)) {
            return adapter.cast((Object)this);
        }
        if (adapter.equals(IDebugTarget.class)) {
            IDebugTarget[] iDebugTargetArray = this.getLaunch().getDebugTargets();
            int n = iDebugTargetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugTarget target = iDebugTargetArray[n2];
                if (((Object)((Object)this)).equals(target.getProcess())) {
                    return adapter.cast(target);
                }
                ++n2;
            }
            return null;
        }
        if (adapter.equals(ILaunch.class)) {
            return adapter.cast(this.getLaunch());
        }
        if (adapter.equals(ILaunchConfiguration.class)) {
            return adapter.cast(this.getLaunch().getLaunchConfiguration());
        }
        return (T)super.getAdapter(adapter);
    }

    public String getLabel() {
        return this.name;
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }
}

