/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.handler;

import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugVariable;
import org.eclipse.fordiac.ide.model.data.BoolType;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class ToggleBoolVariableHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ToggleBoolVariableHandler.getVariables(HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event)).forEachOrdered(ToggleBoolVariableHandler::toggleValue);
        return null;
    }

    private static void toggleValue(EvaluatorDebugVariable variable) {
        if (variable.getInternalVariable().getType() instanceof BoolType) {
            String newValue = Boolean.parseBoolean(variable.getInternalVariable().getValue().toString()) ? "FALSE" : "TRUE";
            try {
                variable.setValue(newValue);
            }
            catch (DebugException e) {
                ErrorDialog.openError(null, null, null, (IStatus)Status.error((String)e.getLocalizedMessage(), (Throwable)e));
            }
        }
    }

    public void setEnabled(Object evaluationContext) {
        IStructuredSelection selection;
        Object object = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        this.setBaseEnabled(object instanceof IStructuredSelection && ToggleBoolVariableHandler.getVariables(selection = (IStructuredSelection)object).allMatch(ToggleBoolVariableHandler::isValidValue));
    }

    private static boolean isValidValue(EvaluatorDebugVariable variable) {
        return variable.supportsValueModification() && variable.getInternalVariable().getType() instanceof BoolType;
    }

    private static Stream<EvaluatorDebugVariable> getVariables(IStructuredSelection selection) {
        return selection.stream().filter(EvaluatorDebugVariable.class::isInstance).map(EvaluatorDebugVariable.class::cast);
    }
}

