/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import org.eclipse.fordiac.ide.application.properties.StructManipulatorSection;
import org.eclipse.fordiac.ide.model.CheckableStructTree;
import org.eclipse.fordiac.ide.model.CheckableStructTreeNode;
import org.eclipse.fordiac.ide.model.StructTreeContentProvider;
import org.eclipse.fordiac.ide.model.commands.create.AddDemuxPortCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteDemuxPortCommand;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.TreeViewer;

public class DemultiplexerSection
extends StructManipulatorSection {
    @Override
    protected ICheckStateListener getCheckStateListener() {
        return new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CheckableStructTreeNode node = (CheckableStructTreeNode)event.getElement();
                Command cmd = this.createDemuxPortCommand(node);
                if (cmd.canExecute()) {
                    DemultiplexerSection.this.executeCommand(cmd);
                    DemultiplexerSection.this.selectStructManipulator(cmd);
                } else {
                    node.updateNode(!event.getChecked());
                }
            }

            private Command createDemuxPortCommand(CheckableStructTreeNode node) {
                if (!node.isChecked() || node.isGrayChecked()) {
                    return new AddDemuxPortCommand(DemultiplexerSection.this.getType(), node);
                }
                return new DeleteDemuxPortCommand(DemultiplexerSection.this.getType(), node);
            }
        };
    }

    @Override
    protected void initTree(StructManipulator manipulator, TreeViewer viewer) {
        StructuredType struct = manipulator.getTypeEntry().getTypeLibrary().getDataTypeLibrary().getStructuredType(PackageNameHelper.getFullTypeName((LibraryElement)manipulator.getDataType()));
        CheckableStructTree tree = viewer != null ? new CheckableStructTree(manipulator, struct, viewer) : new CheckableStructTree(manipulator, struct);
        ((StructTreeContentProvider)this.getViewer().getContentProvider()).setRoot(tree.getRoot());
    }

    @Override
    protected ICheckStateProvider getCheckStateProvider() {
        return new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                if (element != null) {
                    CheckableStructTreeNode node = (CheckableStructTreeNode)element;
                    return node.isChecked() || node.isGrey();
                }
                return false;
            }

            public boolean isGrayed(Object element) {
                CheckableStructTreeNode node = (CheckableStructTreeNode)element;
                return node.isGrey();
            }
        };
    }

    private void selectStructManipulator(Command cmd) {
        Demultiplexer type = null;
        if (cmd instanceof AddDemuxPortCommand) {
            AddDemuxPortCommand addCommand = (AddDemuxPortCommand)cmd;
            type = addCommand.getType();
        }
        if (cmd instanceof DeleteDemuxPortCommand) {
            DeleteDemuxPortCommand deleteCommand = (DeleteDemuxPortCommand)cmd;
            type = deleteCommand.getType();
        }
        this.setInitTree(false);
        this.blockRefresh = true;
        DemultiplexerSection.updateStructManipulatorFB((StructManipulator)type);
        this.setInitTree(true);
        this.blockRefresh = false;
    }

    protected void setInitTree(boolean initTree) {
        this.initTree = initTree;
    }

    protected Demultiplexer getType() {
        return (Demultiplexer)super.getType();
    }

    @Override
    public void stackChanged(CommandStackEvent event) {
        if (event.getDetail() == 32 || event.getDetail() == 16) {
            Command command = event.getCommand();
            if (command instanceof AddDemuxPortCommand || command instanceof DeleteDemuxPortCommand) {
                this.selectStructManipulator(command);
            }
            super.stackChanged(event);
        }
    }
}

