/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.application.commands.ResizeGroupOrSubappCommand;
import org.eclipse.fordiac.ide.application.editors.FBNetworkContextMenuProvider;
import org.eclipse.fordiac.ide.application.editparts.AbstractContainerContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.GroupEditPart;
import org.eclipse.fordiac.ide.application.editparts.IContainerEditPart;
import org.eclipse.fordiac.ide.model.commands.change.AddElementsToGroup;
import org.eclipse.fordiac.ide.model.commands.create.AbstractCreateFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

abstract class AbstractContainerElementHandler
extends AbstractHandler {
    Group group;

    AbstractContainerElementHandler() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.group = null;
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        GraphicalViewer viewer = HandlerHelper.getViewer((IEditorPart)activeEditor);
        CommandStack cmdstack = (CommandStack)activeEditor.getAdapter(CommandStack.class);
        FBNetwork network = this.getFBNetwork(selection, event);
        if (network != null) {
            Rectangle posSizeRef = this.getPosSizeRef(event, (EditPartViewer)viewer, selection, network);
            Command cmd = this.createContainerCreationCommand(selection.toList(), network, posSizeRef);
            FBNetworkElement newElement = ((AbstractCreateFBNetworkElementCommand)cmd).getElement();
            if (this.group != null) {
                cmd = cmd.chain((Command)new AddElementsToGroup(this.group, List.of(newElement), new Point()));
            }
            if (!this.isEditorRootNetwork(event, network)) {
                cmd = new ResizeGroupOrSubappCommand(this.getContainerEP((EditPartViewer)viewer, network), cmd);
            }
            cmdstack.execute(cmd);
            HandlerHelper.selectElement((Object)newElement, (GraphicalViewer)viewer);
        }
        return Status.OK_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        ISelection sel = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        boolean enabeled = false;
        if (sel instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)sel;
            enabeled = AbstractContainerElementHandler.createNewEmptyContainerElement(selection) ? true : selection.toList().stream().map(AbstractContainerElementHandler::getModelElement).filter(FBNetworkElement.class::isInstance).map(fbel -> ((FBNetworkElement)fbel).getFbNetwork()).distinct().count() == 1L;
        }
        this.setBaseEnabled(enabeled);
    }

    protected abstract Command createContainerCreationCommand(List<?> var1, FBNetwork var2, Rectangle var3);

    private FBNetwork getFBNetwork(StructuredSelection selection, ExecutionEvent event) {
        if (AbstractContainerElementHandler.createNewEmptyContainerElement(selection)) {
            return this.getFBNetworkFromContainer(selection.getFirstElement(), event);
        }
        for (Object o : selection) {
            EditPart ep;
            Object object;
            if (!(o instanceof EditPart) || !((object = (ep = (EditPart)o).getModel()) instanceof FBNetworkElement)) continue;
            FBNetworkElement fbnEl = (FBNetworkElement)object;
            this.group = fbnEl.getGroup();
            return fbnEl.getFbNetwork();
        }
        return null;
    }

    protected FBNetwork getFBNetworkFromContainer(Object selection, ExecutionEvent event) {
        if (selection instanceof AbstractContainerContentEditPart) {
            AbstractContainerContentEditPart cEP = (AbstractContainerContentEditPart)((Object)selection);
            FBNetworkElement containerElement = cEP.getContainerElement();
            if (containerElement instanceof Group) {
                Group g;
                this.group = g = (Group)containerElement;
                return containerElement.getFbNetwork();
            }
            if (containerElement instanceof SubApp) {
                SubApp subApp = (SubApp)containerElement;
                return subApp.getSubAppNetwork();
            }
        }
        return (FBNetwork)HandlerUtil.getActiveEditor((ExecutionEvent)event).getAdapter(FBNetwork.class);
    }

    public Rectangle getPosSizeRef(ExecutionEvent event, EditPartViewer viewer, StructuredSelection selection, FBNetwork network) {
        if (AbstractContainerElementHandler.createNewEmptyContainerElement(selection)) {
            return this.getEmptyContainerPosSizeRef(event, viewer, network);
        }
        Rectangle selectionExtend = null;
        for (Object selElem : selection.toList()) {
            GraphicalEditPart gEP;
            Object object;
            if (!(selElem instanceof GraphicalEditPart) || !((object = (gEP = (GraphicalEditPart)selElem).getModel()) instanceof FBNetworkElement)) continue;
            FBNetworkElement fbnEl = (FBNetworkElement)object;
            Rectangle fbBounds = gEP.getFigure().getBounds();
            Point position = fbnEl.getPosition().toScreenPoint();
            fbBounds.x = position.x;
            fbBounds.y = position.y;
            if (selectionExtend == null) {
                selectionExtend = fbBounds.getCopy();
                continue;
            }
            selectionExtend.union(fbBounds);
        }
        AbstractContainerElementHandler.applySnapToGrid(selectionExtend, this.getTargetEP(event, viewer, network));
        return selectionExtend;
    }

    protected Rectangle getEmptyContainerPosSizeRef(ExecutionEvent event, EditPartViewer viewer, FBNetwork network) {
        org.eclipse.swt.graphics.Point point = Optional.ofNullable(((FBNetworkContextMenuProvider)viewer.getContextMenu()).getPoint()).orElse(new org.eclipse.swt.graphics.Point(0, 0));
        Rectangle selectionExtend = new Rectangle(point.x, point.y, 200, 100);
        GraphicalEditPart gep = this.getTargetEP(event, viewer, network);
        IFigure targetFigure = gep.getFigure();
        targetFigure.translateToRelative((Translatable)selectionExtend);
        AbstractContainerElementHandler.applySnapToGrid(selectionExtend, gep);
        if (!this.isEditorRootNetwork(event, network)) {
            Rectangle bounds = targetFigure.getClientArea();
            selectionExtend.translate(-bounds.x, -bounds.y);
        }
        return selectionExtend;
    }

    protected GraphicalEditPart getTargetEP(ExecutionEvent event, EditPartViewer viewer, FBNetwork network) {
        Map editPartRegistry = viewer.getEditPartRegistry();
        if (this.group != null) {
            return ((GroupEditPart)editPartRegistry.get(this.group)).getContentEP();
        }
        if (this.isEditorRootNetwork(event, network)) {
            return (GraphicalEditPart)editPartRegistry.get(network);
        }
        return ((IContainerEditPart)editPartRegistry.get(network.eContainer())).getContentEP();
    }

    private static void applySnapToGrid(Rectangle selectionExtend, GraphicalEditPart gep) {
        SnapToHelper helper = (SnapToHelper)gep.getAdapter(SnapToHelper.class);
        if (helper != null) {
            Point refPoint = new Point(selectionExtend.x, selectionExtend.y);
            gep.getFigure().translateToAbsolute((Translatable)refPoint);
            PrecisionPoint preciseLocation = new PrecisionPoint(refPoint);
            PrecisionPoint result = new PrecisionPoint(refPoint);
            helper.snapPoint(null, 192, preciseLocation, result);
            gep.getFigure().translateToRelative((Translatable)result);
            selectionExtend.x = result.x;
            selectionExtend.y = result.y;
        }
    }

    private boolean isEditorRootNetwork(ExecutionEvent event, FBNetwork network) {
        return this.group == null && HandlerUtil.getActiveEditor((ExecutionEvent)event).getAdapter(FBNetwork.class) == network;
    }

    protected static boolean createNewEmptyContainerElement(StructuredSelection selection) {
        EditPart ep;
        Object object;
        return selection.size() == 1 && (object = selection.getFirstElement()) instanceof EditPart && !((ep = (EditPart)object).getModel() instanceof FBNetworkElement);
    }

    protected static Object getModelElement(Object obj) {
        if (obj instanceof EditPart) {
            EditPart ep = (EditPart)obj;
            return ep.getModel();
        }
        return obj;
    }

    private GraphicalEditPart getContainerEP(EditPartViewer viewer, FBNetwork network) {
        Map editPartRegistry = viewer.getEditPartRegistry();
        if (this.group != null) {
            return ((GroupEditPart)editPartRegistry.get(this.group)).getContentEP();
        }
        return ((IContainerEditPart)editPartRegistry.get(network.eContainer())).getContentEP();
    }
}

