/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.orthogonal.direction;

import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegment;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.direction.BaseRoutingDirectionStrategy;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;

class NorthToSouthRoutingStrategy
extends BaseRoutingDirectionStrategy {
    NorthToSouthRoutingStrategy() {
    }

    @Override
    public double getPortPositionOnHyperNode(LPort port) {
        return port.getNode().getPosition().x + port.getPosition().x + port.getAnchor().x;
    }

    @Override
    public PortSide getSourcePortSide() {
        return PortSide.SOUTH;
    }

    @Override
    public PortSide getTargetPortSide() {
        return PortSide.NORTH;
    }

    @Override
    public void calculateBendPoints(HyperEdgeSegment segment, double startPos, double edgeSpacing) {
        if (segment.isDummy()) {
            return;
        }
        double segmentY = startPos + (double)segment.getRoutingSlot() * edgeSpacing;
        for (LPort port : segment.getPorts()) {
            double sourceX = port.getAbsoluteAnchor().x;
            for (LEdge edge : port.getOutgoingEdges()) {
                if (edge.isSelfLoop()) continue;
                LPort target = edge.getTarget();
                double targetX = target.getAbsoluteAnchor().x;
                if (!(Math.abs(sourceX - targetX) > 0.001)) continue;
                double currentY = segmentY;
                HyperEdgeSegment currentSegment = segment;
                KVector bend = new KVector(sourceX, currentY);
                edge.getBendPoints().add((Object)bend);
                this.addJunctionPointIfNecessary(edge, currentSegment, bend, false);
                HyperEdgeSegment splitPartner = segment.getSplitPartner();
                if (splitPartner != null) {
                    double splitX = splitPartner.getIncomingConnectionCoordinates().get(0);
                    bend = new KVector(splitX, currentY);
                    edge.getBendPoints().add((Object)bend);
                    this.addJunctionPointIfNecessary(edge, currentSegment, bend, false);
                    currentY = startPos + (double)splitPartner.getRoutingSlot() * edgeSpacing;
                    currentSegment = splitPartner;
                    bend = new KVector(splitX, currentY);
                    edge.getBendPoints().add((Object)bend);
                    this.addJunctionPointIfNecessary(edge, currentSegment, bend, false);
                }
                bend = new KVector(targetX, currentY);
                edge.getBendPoints().add((Object)bend);
                this.addJunctionPointIfNecessary(edge, currentSegment, bend, false);
            }
        }
    }
}

