/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeBackgroundcolorCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.ColorizableElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AppearancePropertySection
extends AbstractSection {
    private org.eclipse.swt.graphics.Color color;
    private Canvas colorLabel;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormLayout layout = (FormLayout)composite.getLayout();
        layout.spacing = 3;
        this.initializeControls(parent);
    }

    @Override
    protected void performRefresh() {
        if (this.getType().getColor() != null) {
            Color col = this.getType().getColor();
            this.color = new org.eclipse.swt.graphics.Color(new RGB(col.getRed(), col.getGreen(), col.getBlue()));
            this.colorLabel.setBackground(this.color);
        } else {
            this.color = new org.eclipse.swt.graphics.Color(new RGB(255, 255, 255));
            this.colorLabel.setBackground(this.color);
        }
    }

    protected void initializeControls(Composite parent) {
        this.createColorsGroup(parent);
    }

    protected void createColorsGroup(Composite parent) {
        final Group colorsGroup = this.getWidgetFactory().createGroup(parent, Messages.AppearancePropertySection_LABEL_Color);
        GridLayout layout = new GridLayout(1, false);
        colorsGroup.setLayout((Layout)layout);
        this.color = new org.eclipse.swt.graphics.Color(null, new RGB(255, 255, 255));
        this.colorLabel = new Canvas((Composite)colorsGroup, 0);
        this.colorLabel.setBackground(this.color);
        this.colorLabel.addPaintListener(e -> {
            e.gc.setBackground(this.color);
            e.gc.fillRectangle(this.colorLabel.getClientArea());
        });
        Button chooseColorBtn = new Button((Composite)colorsGroup, 8);
        chooseColorBtn.setText(Messages.AppearancePropertySection_LABEL_BackgroundColor);
        chooseColorBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(colorsGroup.getShell());
                dlg.setRGB(AppearancePropertySection.this.color.getRGB());
                dlg.setText(Messages.AppearancePropertySection_LABEL_ChooseColor);
                RGB rgb = dlg.open();
                if (rgb != null) {
                    AppearancePropertySection.this.executeCommand((Command)new ChangeBackgroundcolorCommand(AppearancePropertySection.this.getType(), rgb));
                    AppearancePropertySection.this.performRefresh();
                }
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)chooseColorBtn);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(-1, chooseColorBtn.computeSize((int)-1, (int)-1).y).applyTo((Control)this.colorLabel);
    }

    protected ColorizableElement getType() {
        return (ColorizableElement)this.type;
    }

    @Override
    protected Object getInputType(Object input) {
        Object inputToUse = input;
        if (inputToUse instanceof EditPart) {
            EditPart ep = (EditPart)inputToUse;
            inputToUse = ep.getModel();
        }
        if (inputToUse instanceof ColorizableElement) {
            ColorizableElement colEl = (ColorizableElement)inputToUse;
            return colEl;
        }
        return null;
    }

    @Override
    protected void setInputCode() {
    }

    @Override
    protected void setInputInit() {
    }
}

