/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Control;

public class LabelCellEditorLocator
implements CellEditorLocator {
    private Point refPoint = new Point(0, 0);
    private final Label label;
    private final ZoomManager zoomManager;
    private final FigureCanvas fc;

    public LabelCellEditorLocator(Label label, ZoomManager zoomManager, FigureCanvas fc) {
        this.label = label;
        this.zoomManager = zoomManager;
        this.fc = fc;
    }

    public void relocate(CellEditor celleditor) {
        if (celleditor != null) {
            Control control = celleditor.getControl();
            this.updateRefPoint();
            Point pref = new Point(control.computeSize((int)-1, (int)-1).x, control.computeSize((int)-1, (int)-1).y);
            control.setBounds(this.refPoint.x - pref.x / 2, this.refPoint.y - pref.y / 2, pref.x + 1, pref.y + 1);
        }
    }

    private void updateRefPoint() {
        Point typeLabelTopLeft = this.label.getBounds().getCenter().scale(this.zoomManager.getZoom());
        Point location = this.fc.getViewport().getViewLocation();
        this.refPoint = new Point(typeLabelTopLeft.x - location.x, typeLabelTopLeft.y - location.y);
    }

    public void setRefPoint(Point refPoint) {
        this.refPoint = refPoint;
    }

    public Point getRefPoint() {
        return this.refPoint;
    }
}

