/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.conflict;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ComparisonCanceledException;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.conflict.IConflictDetector;
import org.eclipse.emf.compare.internal.conflict.AbstractConflictSearch;
import org.eclipse.emf.compare.internal.conflict.ConflictSearchFactory;

public class MatchBasedConflictDetector
implements IConflictDetector {
    @Override
    public void detect(Comparison comparison, Monitor monitor) {
        EList<Diff> differences = comparison.getDifferences();
        int diffCount = differences.size();
        ConflictSearchFactory conflictSearchFactory = new ConflictSearchFactory(comparison, monitor);
        int i = 0;
        while (i < diffCount) {
            if (i % 100 == 0) {
                monitor.subTask(EMFCompareMessages.getString("DefaultConflictDetector.monitor.detect", i + 1, diffCount));
                if (monitor.isCanceled()) {
                    throw new ComparisonCanceledException();
                }
            }
            Diff diff = (Diff)differences.get(i);
            AbstractConflictSearch search = (AbstractConflictSearch)conflictSearchFactory.doSwitch(diff);
            search.detectConflicts();
            ++i;
        }
    }
}

