/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.wrapping;

import java.util.Collections;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.intermediate.wrapping.GraphStats;
import org.eclipse.elk.alg.layered.options.LayeredOptions;

public interface ICutIndexCalculator {
    public List<Integer> getCutIndexes(LGraph var1, GraphStats var2);

    public boolean guaranteeValid();

    public static class ManualCutIndexCalculator
    implements ICutIndexCalculator {
        @Override
        public List<Integer> getCutIndexes(LGraph graph, GraphStats gs) {
            List cuts = (List)graph.getProperty(LayeredOptions.WRAPPING_CUTTING_CUTS);
            if (cuts != null) {
                return cuts;
            }
            return Collections.emptyList();
        }

        @Override
        public boolean guaranteeValid() {
            return false;
        }
    }
}

