/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.edit;

import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.commands.change.ChangeImportNamespaceCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteImportCommand;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ModelEdit;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ImportEdit
extends ModelEdit<Import> {
    private final String newValue;
    private String oldValue;

    public ImportEdit(String name, URI elementURI, String newValue) {
        super(name, elementURI, Import.class);
        this.newValue = newValue;
    }

    @Override
    protected Command createCommand(Import element) {
        if (this.newValue == null || this.newValue.isBlank()) {
            return new DeleteImportCommand((CompilerInfo)element.eContainer(), element);
        }
        return new ChangeImportNamespaceCommand(element, this.newValue);
    }

    @Override
    public void initializeValidationData(Import element, IProgressMonitor pm) {
        this.oldValue = element.getImportedNamespace();
    }

    @Override
    public RefactoringStatus isValid(Import element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (!Objects.equals(element.getImportedNamespace(), this.oldValue)) {
            status.addFatalError(Messages.ImportChange_ImportedNamespaceChanged);
        }
        return status;
    }
}

