/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring;

import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class ModelEdit<T extends EObject>
extends Change {
    private final String name;
    private final URI elementURI;
    private final Class<T> elementClass;

    protected ModelEdit(String name, URI elementURI, Class<T> elementClass) {
        this.name = Objects.requireNonNull(name);
        this.elementURI = Objects.requireNonNull(elementURI);
        this.elementClass = Objects.requireNonNull(elementClass);
    }

    public final void initializeValidationData(LibraryElement libraryElement, IProgressMonitor pm) {
        T element = this.getElement(libraryElement);
        if (element != null) {
            this.initializeValidationData(element, pm);
        }
    }

    public abstract void initializeValidationData(T var1, IProgressMonitor var2);

    public final RefactoringStatus isValid(LibraryElement libraryElement, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        T element = this.getElement(libraryElement);
        if (element == null) {
            status.addFatalError(MessageFormat.format(Messages.AbstractCommandChange_NoSuchElement, this.elementURI));
        } else {
            status.merge(this.isValid(element, pm));
        }
        return status;
    }

    public abstract RefactoringStatus isValid(T var1, IProgressMonitor var2) throws CoreException, OperationCanceledException;

    public final Command createCommand(LibraryElement libraryElement) throws CoreException {
        T element = this.getElement(libraryElement);
        if (element == null) {
            throw new CoreException(Status.error((String)MessageFormat.format(Messages.AbstractCommandChange_NoSuchElement, this.elementURI)));
        }
        return Objects.requireNonNull(this.createCommand(element));
    }

    protected abstract Command createCommand(T var1);

    public String getName() {
        return this.name;
    }

    public final URI getElementURI() {
        return this.elementURI;
    }

    public final URI getLibraryElementURI() {
        return this.elementURI.trimFragment();
    }

    public final Class<T> getElementClass() {
        return this.elementClass;
    }

    private T getElement(LibraryElement libraryElement) {
        Object element;
        if (libraryElement != null && libraryElement.eResource() != null && this.elementClass.isInstance(element = this.elementURI.hasFragment() ? libraryElement.eResource().getEObject(this.elementURI.fragment()) : libraryElement)) {
            return (T)((EObject)this.elementClass.cast(element));
        }
        return null;
    }

    public final void initializeValidationData(IProgressMonitor pm) {
        throw new UnsupportedOperationException();
    }

    public final RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        throw new UnsupportedOperationException();
    }

    public final Change perform(IProgressMonitor pm) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public final Object getModifiedElement() {
        return null;
    }
}

