/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor;

import org.eclipse.fordiac.ide.fbtypeeditor.DataTypeCreationFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.Messages;
import org.eclipse.fordiac.ide.gef.preferences.PaletteFlyoutPreferences;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;

public final class FBInterfacePaletteFactory {
    public static final PaletteFlyoutPreferences PALETTE_PREFERENCES = new PaletteFlyoutPreferences("FBInterfacePaletteFactory.Location", "FBInterfacePaletteFactory.Size", "FBInterfacePaletteFactory.State");

    public static PaletteRoot createPalette(TypeLibrary typeLib, boolean createAdapterEntries) {
        PaletteRoot palette = new PaletteRoot();
        palette.add((PaletteEntry)FBInterfacePaletteFactory.createEventDrawer());
        palette.add((PaletteEntry)FBInterfacePaletteFactory.createDataTypeDrawer(typeLib));
        if (createAdapterEntries) {
            FBInterfacePaletteFactory.createAdapterEntry(palette, typeLib);
        }
        return palette;
    }

    private static PaletteDrawer createEventDrawer() {
        PaletteDrawer drawer = new PaletteDrawer(Messages.FBInterfacePaletteFactory_EventTypes);
        for (DataType type : EventTypeLibrary.getInstance().getEventTypes()) {
            ImageDescriptor desc = FordiacImage.ICON_DATA_TYPE.getImageDescriptor();
            CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry(type.getName(), type.getComment(), (CreationFactory)new DataTypeCreationFactory(type), desc, desc);
            drawer.add((PaletteEntry)combined);
        }
        return drawer;
    }

    private static PaletteDrawer createDataTypeDrawer(TypeLibrary typeLib) {
        PaletteDrawer drawer = new PaletteDrawer(Messages.FBInterfacePaletteFactory_DataTypes);
        for (DataType dataType : typeLib.getDataTypeLibrary().getDataTypesSorted()) {
            ImageDescriptor desc = FordiacImage.ICON_DATA_TYPE.getImageDescriptor();
            CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry(dataType.getName(), dataType.getComment(), (CreationFactory)new DataTypeCreationFactory(dataType), desc, desc);
            drawer.add((PaletteEntry)combined);
        }
        return drawer;
    }

    private static void createAdapterEntry(PaletteRoot palette, TypeLibrary typeLib) {
        PaletteDrawer drawer = new PaletteDrawer(Messages.FBInterfacePaletteFactory_AdapterTypes);
        for (AdapterTypeEntry entry : typeLib.getAdapterTypesSorted()) {
            ImageDescriptor desc = FordiacImage.ICON_DATA_TYPE.getImageDescriptor();
            drawer.add((PaletteEntry)new CombinedTemplateCreationEntry(entry.getTypeName(), entry.getType().getComment(), (CreationFactory)new DataTypeCreationFactory((DataType)entry.getType()), desc, desc));
        }
        if (!drawer.getChildren().isEmpty()) {
            palette.add((PaletteEntry)drawer);
        }
    }

    private FBInterfacePaletteFactory() {
        throw new UnsupportedOperationException("Class FBInterfacePaletteFactory should not be created!\n");
    }
}

