/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.completion;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.console.completion.CommandLineParser;
import org.eclipse.equinox.console.completion.common.Completer;

public class StringsCompleter
implements Completer {
    private final Set<String> strings;
    private final boolean isCaseSensitive;

    public StringsCompleter(Set<String> strings, boolean isCaseSensitive) {
        this.strings = strings;
        this.isCaseSensitive = isCaseSensitive;
    }

    @Override
    public Map<String, Integer> getCandidates(String buffer, int cursor) {
        String currentToken = CommandLineParser.getCurrentToken(buffer, cursor);
        if (currentToken == null) {
            return new HashMap<String, Integer>();
        }
        if (!this.isCaseSensitive) {
            currentToken = currentToken.toLowerCase();
        }
        int startIndex = cursor - currentToken.length();
        if (currentToken.equals("") && buffer.charAt(startIndex - 1) != '$') {
            return new HashMap<String, Integer>();
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (String candidate : this.strings) {
            if (this.isCaseSensitive) {
                if (!candidate.startsWith(currentToken)) continue;
                result.put(candidate, startIndex);
                continue;
            }
            if (!candidate.toLowerCase().startsWith(currentToken)) continue;
            result.put(candidate, startIndex);
        }
        return result;
    }
}

