/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fmu.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.fordiac.ide.fmu.Messages;
import org.eclipse.fordiac.ide.fmu.wizard.CreateFMUWizardPage;
import org.eclipse.fordiac.ide.fmu.wizard.FMUDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.providers.DialogSettingsProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CreateFMUWizard
extends Wizard
implements IExportWizard {
    private static final String FORDIAC_CREATE_FMU_SECTION = "4DIAC_CREATE_FMU_SECTION";
    private IStructuredSelection selection;
    private CreateFMUWizardPage page;

    public CreateFMUWizard() {
        this.setWindowTitle(Messages.FordiacCreateFMUWizard_LABEL_Window_Title);
        IDialogSettings settings = DialogSettingsProvider.getDialogSettings(((Object)((Object)this)).getClass());
        IDialogSettings dialogSettings = settings.getSection(FORDIAC_CREATE_FMU_SECTION);
        if (dialogSettings == null) {
            settings.addNewSection(FORDIAC_CREATE_FMU_SECTION);
        }
        this.setDialogSettings(settings);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = new StructuredSelection(selection.toList());
    }

    public void addPages() {
        super.addPages();
        this.page = new CreateFMUWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        if (this.page.getStoreSelectedLibaries().getSelection()) {
            ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.fordiac.ide.fmu");
            store.setValue("win32", this.page.getWin32Field().getSelection());
            store.setValue("win64", this.page.getWin64Field().getSelection());
            store.setValue("linux32", this.page.getLinux32Field().getSelection());
            store.setValue("linux64", this.page.getLinux64Field().getSelection());
        }
        IRunnableWithProgress iop = monitor -> {
            String outputDirectory = this.page.getDirectory();
            Map<Device, List<Resource>> toDeploy = this.addResourcesAndDevices();
            List<String> librariesToAdd = this.getLibraries();
            for (Map.Entry<Device, List<Resource>> entry : toDeploy.entrySet()) {
                FMUDeviceManagementCommunicationHandler.createFMU(entry.getKey(), entry.getValue(), librariesToAdd, outputDirectory, this.getShell(), monitor);
            }
            monitor.done();
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, false, iop);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.showCreationExceptionDialog(e);
        }
        catch (Exception e) {
            this.showCreationExceptionDialog(e);
        }
        return true;
    }

    protected void showCreationExceptionDialog(Exception e) {
        MessageBox msg = new MessageBox(this.getShell(), 1);
        msg.setMessage(Messages.CreateFMUWizard_FMUCreationError + e.getMessage());
        msg.open();
        FordiacLogHelper.logError((String)msg.getMessage(), (Throwable)e);
    }

    private List<String> getLibraries() {
        ArrayList<String> libs = new ArrayList<String>();
        if (this.page.getWin32Field().isEnabled() && this.page.getWin32Field().getSelection()) {
            libs.add("win32");
        }
        if (this.page.getWin64Field().isEnabled() && this.page.getWin64Field().getSelection()) {
            libs.add("win64");
        }
        if (this.page.getLinux32Field().isEnabled() && this.page.getLinux32Field().getSelection()) {
            libs.add("linux32");
        }
        if (this.page.getLinux64Field().isEnabled() && this.page.getLinux64Field().getSelection()) {
            libs.add("linux64");
        }
        return libs;
    }

    private Map<Device, List<Resource>> addResourcesAndDevices() {
        Object[] selectedElements = this.page.getSelectedElements();
        HashMap<Device, List<Resource>> toDeploy = new HashMap<Device, List<Resource>>();
        Object[] objectArray = selectedElements;
        int n = selectedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof Resource) {
                CreateFMUWizard.insertResource(toDeploy, (Resource)object);
            } else if (object instanceof Device) {
                CreateFMUWizard.getWorkLoadEntryList(toDeploy, (Device)object);
            }
            ++n2;
        }
        return toDeploy;
    }

    private static void insertResource(Map<Device, List<Resource>> workLoad, Resource res) {
        List<Resource> resList = CreateFMUWizard.getWorkLoadEntryList(workLoad, res.getDevice());
        resList.add(res);
    }

    private static List<Resource> getWorkLoadEntryList(Map<Device, List<Resource>> toDeploy, Device device) {
        return toDeploy.computeIfAbsent(device, dev -> new ArrayList());
    }
}

