/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManagerModel;
import org.openstreetmap.josm.gui.dialogs.properties.PropertiesDialog;
import org.openstreetmap.josm.tools.I18n;

public class ChangesetTagsPanel
extends JPanel
implements PropertyChangeListener {
    private PropertiesDialog.ReadOnlyTableModel model;

    protected void build() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.model = new PropertiesDialog.ReadOnlyTableModel();
        this.model.setColumnIdentifiers(new String[]{I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])});
        JTable tblTags = new JTable(this.model);
        tblTags.setAutoCreateRowSorter(true);
        tblTags.getTableHeader().setReorderingAllowed(false);
        this.add((Component)new JScrollPane(tblTags), "Center");
    }

    public ChangesetTagsPanel() {
        this.build();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals(ChangesetCacheManagerModel.CHANGESET_IN_DETAIL_VIEW_PROP)) {
            return;
        }
        this.model.setRowCount(0);
        Changeset cs = (Changeset)evt.getNewValue();
        if (cs != null) {
            for (Map.Entry<String, String> tag : cs.getKeys().entrySet()) {
                this.model.addRow(new String[]{tag.getKey(), tag.getValue()});
            }
        }
    }
}

