/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.markdown;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.client.DefaultLanguageClient;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;
import org.eclipse.wildwebdeveloper.markdown.MarkdownDiagnosticsManager;
import org.eclipse.wildwebdeveloper.markdown.MarkdownLanguageServer;
import org.eclipse.wildwebdeveloper.markdown.MarkdownLanguageServerAPI;
import org.eclipse.wildwebdeveloper.markdown.ui.preferences.MarkdownPreferences;
import org.eclipse.wildwebdeveloper.ui.preferences.Settings;
import org.eclipse.wildwebdeveloper.util.FileUtils;

public final class MarkdownLanguageClient
extends DefaultLanguageClient {
    private static volatile String mdParseHelperPath;
    private final Map<Integer, Watcher> watchersById = new ConcurrentHashMap<Integer, Watcher>();

    private static Path resolveResource(String resourcePath) throws IOException {
        try {
            URL url = FileLocator.toFileURL((URL)MarkdownLanguageClient.class.getResource(resourcePath));
            return Paths.get(url.toURI()).toAbsolutePath();
        }
        catch (URISyntaxException ex) {
            throw new IOException("Failed to resolve resource URI: " + resourcePath, ex);
        }
    }

    public MarkdownLanguageClient() throws IOException {
        if (mdParseHelperPath == null) {
            mdParseHelperPath = MarkdownLanguageClient.resolveResource("md-parse.js").toString();
        }
    }

    public CompletableFuture<List<Object>> configuration(ConfigurationParams params) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Object> results = new ArrayList<Object>();
            for (ConfigurationItem item : params.getItems()) {
                String section = item.getSection();
                if (MarkdownPreferences.isMatchMarkdownSection(section)) {
                    Settings md = MarkdownPreferences.getGlobalSettings();
                    results.add(md.findSettings(section.split("[.]")));
                    continue;
                }
                results.add(null);
            }
            return results;
        });
    }

    public CompletableFuture<Void> refreshDiagnostics() {
        return CompletableFuture.runAsync(() -> MarkdownDiagnosticsManager.refreshAllOpenMarkdownFiles(this.getLanguageServer()));
    }

    @JsonRequest(value="markdown/parse")
    public CompletableFuture<List<Map<String, Object>>> parseMarkdown(Map<String, Object> params) {
        return CompletableFuture.supplyAsync(() -> {
            List list;
            Path tmp;
            block32: {
                List list2;
                block31: {
                    tmp = null;
                    try {
                        String argPath;
                        Path p;
                        Object uri;
                        boolean hasText;
                        String text = null;
                        boolean bl = hasText = params != null && params.get("text") instanceof String;
                        if (hasText) {
                            text = (String)params.get("text");
                        }
                        Path uriPath = null;
                        if (params != null && (uri = params.get("uri")) != null && Files.exists(p = FileUtils.uriToPath(uri.toString()), new LinkOption[0])) {
                            uriPath = p;
                        }
                        if (!hasText && uriPath == null) {
                            List list3 = List.of();
                            return list3;
                        }
                        if (hasText) {
                            tmp = Files.createTempFile("wwd-md-", ".md", new FileAttribute[0]);
                            Files.writeString(tmp, (CharSequence)text, StandardCharsets.UTF_8, new OpenOption[0]);
                            argPath = tmp.toAbsolutePath().toString();
                        } else {
                            argPath = uriPath.toAbsolutePath().toString();
                        }
                        ProcessBuilder pb = new ProcessBuilder(List.of(NodeJSManager.getNodeJsLocation().getAbsolutePath(), mdParseHelperPath, argPath));
                        Process proc = pb.start();
                        String out = new String(proc.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
                        int exit = proc.waitFor();
                        if (exit != 0) {
                            String err = new String(proc.getErrorStream().readAllBytes(), StandardCharsets.UTF_8);
                            ILog.get().warn("markdown-it parser failed (" + exit + "): " + err, null);
                            list2 = List.of();
                            if (tmp == null) return list2;
                            break block31;
                        }
                        Gson gson = new Gson();
                        List tokens = (List)gson.fromJson(out, List.class);
                        try {
                            URI uri2 = URI.create((String)params.get("uri"));
                            IResource res = LSPEclipseUtils.findResourceFor((URI)uri2);
                            if (res instanceof IFile) {
                                IFile file = (IFile)res;
                                CompletableFuture.runAsync(() -> MarkdownDiagnosticsManager.refreshFile(file));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        list = tokens != null ? tokens : List.of();
                        if (tmp == null) return list;
                        break block32;
                    }
                    catch (InterruptedException ex) {
                        ILog.get().warn(ex.getMessage(), (Throwable)ex);
                        Thread.currentThread().interrupt();
                        return List.of();
                    }
                    catch (Exception ex) {
                        ILog.get().warn(ex.getMessage(), (Throwable)ex);
                        return List.of();
                    }
                }
                try {
                    Files.deleteIfExists(tmp);
                    return list2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return list2;
            }
            try {
                Files.deleteIfExists(tmp);
                return list;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return list;
            finally {
                if (tmp != null) {
                    try {
                        Files.deleteIfExists(tmp);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @JsonRequest(value="markdown/findMarkdownFilesInWorkspace")
    public CompletableFuture<List<String>> findMarkdownFilesInWorkspace(Object unused) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList uris = new ArrayList();
            String[] excludeGlobs = MarkdownPreferences.getSuggestPathsExcludeGlobs();
            List<PathMatcher> excludeMatchers = MarkdownLanguageClient.compileGlobMatchers(excludeGlobs);
            try {
                Set<String> roots = MarkdownLanguageServer.getServerRoots();
                if (roots != null && !roots.isEmpty()) {
                    for (String rootUri : roots) {
                        IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(URI.create(rootUri));
                        if (containers == null || containers.length <= 0) continue;
                        IContainer[] iContainerArray = containers;
                        int n = containers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IContainer container = iContainerArray[n2];
                            if (!container.isDerived() && !container.isHidden()) {
                                container.accept(res -> {
                                    if (res.isDerived() || res.isHidden()) {
                                        return false;
                                    }
                                    if (res.getType() == 1) {
                                        String name = res.getName().toLowerCase();
                                        if ((name.endsWith(".md") || name.endsWith(".markdown") || name.endsWith(".mdown")) && !MarkdownLanguageClient.isExcludedByGlobs(res, excludeMatchers)) {
                                            uris.add(MarkdownLanguageClient.normalizeFileUriForLanguageServer(res.getLocationURI()));
                                        }
                                        return false;
                                    }
                                    return true;
                                });
                            }
                            ++n2;
                        }
                    }
                } else {
                    IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                    wsRoot.accept(res -> {
                        if (res.isDerived() || res.isHidden()) {
                            return false;
                        }
                        if (res.getType() == 1) {
                            String name = res.getName().toLowerCase();
                            if ((name.endsWith(".md") || name.endsWith(".markdown") || name.endsWith(".mdown")) && !MarkdownLanguageClient.isExcludedByGlobs(res, excludeMatchers)) {
                                uris.add(MarkdownLanguageClient.normalizeFileUriForLanguageServer(res.getLocationURI()));
                            }
                            return false;
                        }
                        return true;
                    });
                }
            }
            catch (Exception ex) {
                ILog.get().warn(ex.getMessage(), (Throwable)ex);
            }
            return uris;
        });
    }

    private static List<PathMatcher> compileGlobMatchers(String ... globs) {
        if (globs == null || globs.length == 0) {
            return List.of();
        }
        FileSystem fs = FileSystems.getDefault();
        ArrayList<PathMatcher> matchers = new ArrayList<PathMatcher>();
        String[] stringArray = globs;
        int n = globs.length;
        int n2 = 0;
        while (n2 < n) {
            String glob = stringArray[n2];
            if (glob != null && !(glob = glob.trim()).isEmpty()) {
                List<String> patterns = glob.startsWith("**/") && glob.length() > 3 ? List.of(glob, glob.substring(3)) : List.of(glob);
                for (String pattern : patterns) {
                    try {
                        matchers.add(fs.getPathMatcher("glob:" + pattern));
                    }
                    catch (Exception ex) {
                        ILog.get().warn(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            ++n2;
        }
        return matchers;
    }

    private static boolean isExcludedByGlobs(IResource res, List<PathMatcher> matchers) {
        if (matchers == null || matchers.isEmpty()) {
            return false;
        }
        IPath pr = res.getProjectRelativePath();
        if (pr == null) {
            return false;
        }
        Path p = pr.toPath();
        for (PathMatcher m : matchers) {
            if (!m.matches(p)) continue;
            return true;
        }
        return false;
    }

    @JsonRequest(value="markdown/fs/readDirectory")
    public CompletableFuture<List<List<Object>>> fsReadDirectory(Map<String, Object> params) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Object uri = params.get("uri");
                if (uri == null) {
                    return List.of();
                }
                return Files.list(FileUtils.uriToPath(uri.toString())).map(child -> List.of(child.getFileName().toString(), Map.of("isDirectory", Files.isDirectory(child, new LinkOption[0])))).toList();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
    }

    @JsonRequest(value="markdown/fs/readFile")
    public CompletableFuture<List<Integer>> fsReadFile(Map<String, Object> params) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Object uri = params.get("uri");
                if (uri == null) {
                    return List.of();
                }
                Path path = FileUtils.uriToPath(uri.toString());
                byte[] bytes = Files.readAllBytes(path);
                ArrayList<Integer> out = new ArrayList<Integer>(bytes.length);
                byte[] byArray = bytes;
                int n = bytes.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    out.add(Byte.toUnsignedInt(b));
                    ++n2;
                }
                return out;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
    }

    @JsonRequest(value="markdown/fs/stat")
    public CompletableFuture<Map<String, Object>> fsStat(Map<String, Object> params) {
        return CompletableFuture.supplyAsync(() -> {
            Object uri = params.get("uri");
            if (uri == null) {
                return null;
            }
            File file = FileUtils.uriToFile(uri.toString());
            if (!file.exists()) {
                return null;
            }
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(1, 1.0f);
            result.put("isDirectory", file.isDirectory());
            return result;
        });
    }

    @JsonRequest(value="markdown/fs/watcher/create")
    public CompletableFuture<Void> fsWatcherCreate(Map<String, Object> params) {
        return CompletableFuture.supplyAsync(() -> {
            int id = ((Number)params.get("id")).intValue();
            Object uri = params.get("uri");
            if (uri == null) {
                return null;
            }
            Path path = uri == null ? null : FileUtils.uriToPath(uri.toString());
            Map options = params.get("options") instanceof Map ? (Map)params.get("options") : Map.of();
            Watcher watcher = new Watcher((MarkdownLanguageServerAPI)this.getLanguageServer(), id, path, Boolean.TRUE.equals(options.get("ignoreCreate")), Boolean.TRUE.equals(options.get("ignoreChange")), Boolean.TRUE.equals(options.get("ignoreDelete")));
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)watcher, 1);
            this.watchersById.put(id, watcher);
            return null;
        });
    }

    @JsonRequest(value="markdown/fs/watcher/delete")
    public CompletableFuture<Void> fsWatcherDelete(Map<String, Object> params) {
        return CompletableFuture.supplyAsync(() -> {
            Number id;
            Watcher watcher;
            Object idObj;
            Object v0 = idObj = params != null ? params.get("id") : null;
            if (idObj instanceof Number && (watcher = this.watchersById.remove((id = (Number)idObj).intValue())) != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)watcher);
            }
            return null;
        });
    }

    private static String normalizeFileUriForLanguageServer(URI uri) {
        if (uri == null) {
            return null;
        }
        if (!"file".equalsIgnoreCase(uri.getScheme())) {
            return uri.toString();
        }
        String uriAsString = uri.toString();
        String withoutScheme = uriAsString.substring("file:".length());
        while (withoutScheme.startsWith("/")) {
            withoutScheme = withoutScheme.substring(1);
        }
        if (withoutScheme.length() >= 2 && Character.isLetter(withoutScheme.charAt(0)) && withoutScheme.charAt(1) == ':') {
            char drive = Character.toLowerCase(withoutScheme.charAt(0));
            String rest = withoutScheme.substring(2);
            return "file:///" + drive + "%3A" + (String)(rest.startsWith("/") ? rest : "/" + rest);
        }
        return uriAsString;
    }

    private static final class Watcher
    implements IResourceChangeListener {
        final int id;
        final Path watchRoot;
        final boolean ignoreCreate;
        final boolean ignoreChange;
        final boolean ignoreDelete;
        final MarkdownLanguageServerAPI server;

        Watcher(MarkdownLanguageServerAPI server, int id, Path watchRoot, boolean ignoreCreate, boolean ignoreChange, boolean ignoreDelete) {
            this.server = server;
            this.id = id;
            this.watchRoot = watchRoot;
            this.ignoreCreate = ignoreCreate;
            this.ignoreChange = ignoreChange;
            this.ignoreDelete = ignoreDelete;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            try {
                delta.accept(deltaNode -> {
                    String kind;
                    IResource res = deltaNode.getResource();
                    if (res == null || res.getType() != 1) {
                        return true;
                    }
                    URI uri = res.getLocationURI();
                    if (uri == null) {
                        return true;
                    }
                    if (this.watchRoot != null) {
                        try {
                            if (!Paths.get(uri).startsWith(this.watchRoot)) {
                                return true;
                            }
                        }
                        catch (Exception ex) {
                            return true;
                        }
                    }
                    switch (deltaNode.getKind()) {
                        case 1: {
                            if (this.ignoreCreate) {
                                return true;
                            }
                            kind = "create";
                            break;
                        }
                        case 2: {
                            if (this.ignoreDelete) {
                                return true;
                            }
                            kind = "delete";
                            break;
                        }
                        case 4: {
                            if (this.ignoreChange) {
                                return true;
                            }
                            if ((deltaNode.getFlags() & 0x100) == 0) {
                                return true;
                            }
                            kind = "change";
                            break;
                        }
                        default: {
                            return true;
                        }
                    }
                    HashMap<String, Object> payload = new HashMap<String, Object>();
                    payload.put("id", this.id);
                    payload.put("uri", MarkdownLanguageClient.normalizeFileUriForLanguageServer(uri));
                    payload.put("kind", kind);
                    this.server.fsWatcherOnChange(payload);
                    return true;
                });
            }
            catch (Exception ex) {
                ILog.get().warn(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

