/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.executioncomparison.core;

import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;

public class TmfComparisonFilteringUpdatedSignal
extends TmfSignal {
    private final ITmfTimestamp fBeginTimeA;
    private final ITmfTimestamp fEndTimeA;
    private final ITmfTimestamp fBeginTimeB;
    private final ITmfTimestamp fEndTimeB;
    private @Nullable String fStatistic;
    private @Nullable List<String> fTraceListA;
    private @Nullable List<String> fTraceListB;

    public TmfComparisonFilteringUpdatedSignal(Object source, ITmfTimestamp beginA, ITmfTimestamp endA, ITmfTimestamp beginB, ITmfTimestamp endB, @Nullable String statistic, @Nullable List<String> traceListA, @Nullable List<String> traceListB) {
        super(source);
        this.fBeginTimeA = beginA;
        this.fEndTimeA = endA;
        this.fBeginTimeB = beginB;
        this.fEndTimeB = endB;
        this.fStatistic = statistic;
        this.fTraceListA = traceListA;
        this.fTraceListB = traceListB;
    }

    public TmfComparisonFilteringUpdatedSignal(Object source, @Nullable String statistic, @Nullable List<String> traceListA, @Nullable List<String> traceListB) {
        this(source, TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH, TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH, statistic, traceListA, traceListB);
    }

    public ITmfTimestamp getBeginTimeA() {
        return this.fBeginTimeA;
    }

    public ITmfTimestamp getEndTimeA() {
        return this.fEndTimeA;
    }

    public ITmfTimestamp getBeginTimeB() {
        return this.fBeginTimeB;
    }

    public ITmfTimestamp getEndTimeB() {
        return this.fEndTimeB;
    }

    public @Nullable String getStatistic() {
        return this.fStatistic;
    }

    public @Nullable List<String> getTraceListA() {
        return this.fTraceListA;
    }

    public @Nullable List<String> getTraceListB() {
        return this.fTraceListB;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(" [");
        if (!TmfTimestamp.BIG_BANG.equals(this.fBeginTimeA)) {
            sb.append(this.fBeginTimeA.toString());
            if (!this.fBeginTimeA.equals(this.fEndTimeA)) {
                sb.append('-');
                sb.append(this.fEndTimeA.toString());
            }
        }
        if (!TmfTimestamp.BIG_BANG.equals(this.fBeginTimeB)) {
            sb.append(this.fBeginTimeB.toString());
            if (!this.fBeginTimeB.equals(this.fEndTimeB)) {
                sb.append('-');
                sb.append(this.fEndTimeB.toString());
            }
        }
        if (this.fStatistic != null) {
            sb.append(this.fStatistic);
        }
        sb.append("]");
        return sb.toString();
    }
}

