/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.debug.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.mylyn.internal.debug.ui.BreakpointsContextUtil;

public class BreakpointsStateUtil {
    public static final String STATE_FILE = "storedBreakpoints.xml";
    private final IPath pluginStateDir;

    public BreakpointsStateUtil(IPath pluginStateDir) {
        this.pluginStateDir = pluginStateDir;
    }

    public void saveState() {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        InputStream exportedBreakpoints = BreakpointsContextUtil.exportBreakpoints(Arrays.asList(breakpoints), (IProgressMonitor)new NullProgressMonitor());
        File stateFile = this.resetStateFile();
        if (exportedBreakpoints != null) {
            this.saveStateFile(stateFile, exportedBreakpoints);
        }
    }

    public void restoreState() {
        File stateFile = this.getStateFile();
        try {
            BreakpointsContextUtil.importBreakpoints(new FileInputStream(stateFile), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private File resetStateFile() {
        File stateFile = this.getStateFile();
        stateFile.getParentFile().mkdirs();
        if (stateFile.exists()) {
            stateFile.delete();
        }
        return stateFile;
    }

    private File getStateFile() {
        return this.pluginStateDir.append(STATE_FILE).toFile();
    }

    private void saveStateFile(File stateFile, InputStream exportedBreakpoints) {
        if (!stateFile.exists()) {
            try {
                stateFile.createNewFile();
            }
            catch (IOException e) {
                return;
            }
        }
        try {
            Throwable e = null;
            Object var4_8 = null;
            try (FileOutputStream output = new FileOutputStream(stateFile);){
                IOUtils.copy((InputStream)exportedBreakpoints, (OutputStream)output);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

