/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples;

import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.ASADatabaseSetting;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.services.ASASQLDataService;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.services.ASASQLService;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.IDatabaseSetting;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.services.SQLDataService;
import org.eclipse.datatools.sqltools.core.services.SQLService;

public class ASAConfig
extends SQLDevToolsConfiguration {
    private static ASAConfig _instance = null;
    public static final String[] ASA_ALIASES = new String[]{"Sybase_ASA", "Adaptive Server Anywhere", "SQL Anywhere"};
    public static final String[] _ALSO_SUPPORT_VERSIONS = new String[]{"10.x"};

    public ASAConfig() {
        _instance = this;
    }

    public static ASAConfig getInstance() {
        if (_instance == null) {
            return new ASAConfig();
        }
        return _instance;
    }

    public IDatabaseSetting createDbSetting(DatabaseIdentifier databaseIdentifier) {
        return new ASADatabaseSetting(databaseIdentifier);
    }

    public boolean recognize(String product, String version) {
        boolean productMatch = false;
        int i = 0;
        while (i < ASA_ALIASES.length) {
            if (ASA_ALIASES[i].equals(product)) {
                productMatch = true;
                break;
            }
            ++i;
        }
        if (productMatch) {
            DatabaseVendorDefinitionId targetid = new DatabaseVendorDefinitionId(product, version);
            DatabaseVendorDefinitionId supportid1 = new DatabaseVendorDefinitionId(product, this.getDatabaseVendorDefinitionId().getVersion());
            if (supportid1.equals((Object)targetid)) {
                return true;
            }
            int i2 = 0;
            while (i2 < this.getAlsoSuppportVersions().length) {
                DatabaseVendorDefinitionId supportid2 = new DatabaseVendorDefinitionId(product, this.getAlsoSuppportVersions()[i2]);
                if (supportid2.equals((Object)targetid)) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    public String[] getAssociatedConnectionProfileType() {
        return new String[]{"org.eclipse.datatools.enablement.sybase.asa.connectionProfile"};
    }

    public DatabaseVendorDefinitionId[] alsoSupport() {
        DatabaseVendorDefinitionId[] targetids = new DatabaseVendorDefinitionId[this.getAlsoSuppportVersions().length];
        int i = 0;
        while (i < this.getAlsoSuppportVersions().length) {
            targetids[i] = new DatabaseVendorDefinitionId(ASA_ALIASES[0], this.getAlsoSuppportVersions()[i]);
            ++i;
        }
        return targetids;
    }

    protected String[] getAlsoSuppportVersions() {
        return _ALSO_SUPPORT_VERSIONS;
    }

    public SQLService getSQLService() {
        return new ASASQLService();
    }

    public SQLDataService getSQLDataService() {
        return new ASASQLDataService();
    }
}

