/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.compare;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.buildship.ui.internal.UiPlugin;
import org.eclipse.buildship.ui.internal.editor.GradleDocumentSetupParticipant;
import org.eclipse.buildship.ui.internal.editor.GradleTextViewerConfiguration;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class GradleViewer
extends Viewer {
    private final SourceViewer sourceViewer;
    private Object input;

    public GradleViewer(Composite parent) {
        this.sourceViewer = new SourceViewer(parent, null, 768);
        this.sourceViewer.setEditable(false);
        this.sourceViewer.configure((SourceViewerConfiguration)new GradleTextViewerConfiguration());
        this.sourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)TextMergeViewer.class.getName()));
    }

    public Control getControl() {
        return this.sourceViewer.getControl();
    }

    public Object getInput() {
        return this.input;
    }

    public ISelection getSelection() {
        return StructuredSelection.EMPTY;
    }

    public void refresh() {
    }

    public void setInput(Object input) {
        this.input = input;
        if (!(input instanceof IStreamContentAccessor) || !(input instanceof IEncodedStreamContentAccessor)) {
            return;
        }
        IEncodedStreamContentAccessor contentAccessor = (IEncodedStreamContentAccessor)input;
        try (InputStream contents = contentAccessor.getContents();){
            if (contents == null) {
                return;
            }
            String charset = contentAccessor.getCharset();
            if (charset == null) {
                charset = ResourcesPlugin.getEncoding();
            }
            InputStreamReader reader = new InputStreamReader(contents, charset);
            Document document = new Document(CharStreams.toString((Readable)reader));
            new GradleDocumentSetupParticipant().setup((IDocument)document);
            this.sourceViewer.setDocument((IDocument)document);
        }
        catch (IOException | CoreException e) {
            UiPlugin.logger().error("Failed to set up input document.", e);
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }
}

