/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Replacements {
    private final LinkedHashMap<AbstractInsnNode, Collection<InstructionBranch>> newBranches = new LinkedHashMap();

    public void add(AbstractInsnNode target, AbstractInsnNode instruction, int branchIndex) {
        Collection<InstructionBranch> from = this.newBranches.get(target);
        if (from == null) {
            from = new ArrayList<InstructionBranch>();
            this.newBranches.put(target, from);
        }
        from.add(new InstructionBranch(instruction, branchIndex));
    }

    public Iterable<Collection<InstructionBranch>> values() {
        return this.newBranches.values();
    }

    static Replacements ignoreDefaultBranch(AbstractInsnNode switchNode) {
        LabelNode defaultLabel;
        List labels;
        LookupSwitchInsnNode s;
        if (switchNode.getOpcode() == 171) {
            s = (LookupSwitchInsnNode)switchNode;
            labels = s.labels;
            defaultLabel = s.dflt;
        } else {
            s = (TableSwitchInsnNode)switchNode;
            labels = s.labels;
            defaultLabel = s.dflt;
        }
        Replacements replacements = new Replacements();
        int branchIndex = 0;
        for (LabelNode label : labels) {
            if (label == defaultLabel || replacements.newBranches.get(label) != null) continue;
            replacements.add((AbstractInsnNode)label, switchNode, ++branchIndex);
        }
        return replacements;
    }

    public static final class InstructionBranch {
        public final AbstractInsnNode instruction;
        public final int branch;

        public InstructionBranch(AbstractInsnNode instruction, int branch) {
            this.instruction = instruction;
            this.branch = branch;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InstructionBranch other = (InstructionBranch)o;
            return this.instruction.equals(other.instruction) && this.branch == other.branch;
        }

        public int hashCode() {
            return this.instruction.hashCode() * 31 + this.branch;
        }
    }
}

