/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dtmanager.converter.operations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dtmanager.converter.ITransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.AbstractTransformOperation;
import org.osgi.framework.Bundle;

public final class TransformOperationFactory {
    public static final String OP_AppendChildElementOperation = PDPlugin.getPluginId() + ".AppendChildElementOperation";
    public static final String OP_AppendChildTextFromXPathOperation = PDPlugin.getPluginId() + ".AppendChildTextFromXPathOperation";
    public static final String OP_AppendChildTextOperation = PDPlugin.getPluginId() + ".AppendChildTextOperation";
    public static final String OP_ConvertAttributeToTextOperation = PDPlugin.getPluginId() + ".ConvertAttributeToTextOperation";
    public static final String OP_CopyAllAttributesOperation = PDPlugin.getPluginId() + ".CopyAllAttributesOperation";
    public static final String OP_CopyAttributeOperation = PDPlugin.getPluginId() + ".CopyAttributeOperation";
    public static final String OP_CopyAttributeWithRenameOperation = PDPlugin.getPluginId() + ".CopyAttributeWithRenameOperation";
    public static final String OP_CopyChildrenOperation = PDPlugin.getPluginId() + ".CopyChildrenOperation";
    public static final String OP_CreateAttributeFromXPathOperation = PDPlugin.getPluginId() + ".CreateAttributeFromXPathOperation";
    public static final String OP_CreateAttributeOperation = PDPlugin.getPluginId() + ".CreateAttributeOperation";
    public static final String OP_CreateElementOperation = PDPlugin.getPluginId() + ".CreateElementOperation";
    public static final String OP_CustomTransformOperation = PDPlugin.getPluginId() + ".CustomTransformOperation";
    public static final String OP_IfNotOperation = PDPlugin.getPluginId() + ".IfNotOperation";
    public static final String OP_IfOperation = PDPlugin.getPluginId() + ".IfOperation";
    public static final String OP_IterateOverElementsOperation = PDPlugin.getPluginId() + ".IterateOverElementsOperation";
    public static final String OP_MakeParentElementCurrentOperation = PDPlugin.getPluginId() + ".MakeParentElementCurrentOperation";
    public static final String OP_RemoveAttributeOperation = PDPlugin.getPluginId() + ".RemoveAttributeOperation";
    public static final String OP_RenameAttributeOperation = PDPlugin.getPluginId() + ".RenameAttributeOperation";
    private static TransformOperationFactory instance;
    private Logger log = PDPlugin.getLogger(TransformOperationFactory.class);
    private Map<String, Class> _tagTransformOpsRegistry;

    private TransformOperationFactory() {
        this.readAllTagTransformOperations();
    }

    public static synchronized TransformOperationFactory getInstance() {
        if (instance == null) {
            instance = new TransformOperationFactory();
        }
        return instance;
    }

    public ITransformOperation getTransformOperation(String opID, String[] params) {
        Class opClass = null;
        try {
            opClass = this._tagTransformOpsRegistry.get(opID);
            if (opClass != null) {
                Object opObject = opClass.newInstance();
                if (opObject instanceof AbstractTransformOperation) {
                    ((AbstractTransformOperation)opObject).setParameters(params);
                    ((AbstractTransformOperation)opObject).setTransformOperationID(opID);
                    return (AbstractTransformOperation)opObject;
                }
                this.log.error("Warning.TransformOperationFactory.NotAbstractTransformOperation", opClass.getName());
            } else {
                this.log.error("Warning.TransformOperationFactory.ExtensionNotFound", opID);
            }
        }
        catch (IllegalAccessException iae) {
            this.log.error("Warning.TransformOperationFactory.IllegalAccess", opClass.getName(), (Throwable)iae);
        }
        catch (InstantiationException ie) {
            this.log.error("Warning.TransformOperationFactory.Instantiation", opClass.getName(), (Throwable)ie);
        }
        return null;
    }

    private void readAllTagTransformOperations() {
        try {
            this._tagTransformOpsRegistry = new HashMap<String, Class>();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(PDPlugin.getPluginId(), "pageDesignerExtension");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension ext = extensions[i];
                int j = 0;
                while (j < ext.getConfigurationElements().length) {
                    if (ext.getConfigurationElements()[j].getName().equals("tagTransformOperation")) {
                        this.registerTransformOperation(ext.getConfigurationElements()[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (InvalidRegistryObjectException e) {
            this.log.error("Warning.TransformOperationFactory.RegistryError", PDPlugin.getPluginId() + "pageDesignerExtension.tagTransformOperation", (Throwable)e);
        }
    }

    private void registerTransformOperation(IConfigurationElement element) {
        Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
        String id = element.getContributor().getName() + "." + element.getAttribute("id");
        if (bundle != null) {
            try {
                Class transformClass = bundle.loadClass(element.getAttribute("class"));
                this._tagTransformOpsRegistry.put(id, transformClass);
            }
            catch (Exception e) {
                this.log.error("Warning.TransformOperationFactory.CannotLoadOpClass", id, (Throwable)e);
            }
        }
    }
}

