/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.databinding.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class EMFPropertyListener
extends AdapterImpl
implements INativePropertyListener {
    public void addTo(Object source) {
        if (source != null) {
            ((EObject)source).eAdapters().add((Object)this);
        }
    }

    public void removeFrom(Object source) {
        if (source != null) {
            ((EObject)source).eAdapters().remove((Object)this);
        }
    }

    public abstract void notifyChanged(Notification var1);

    protected abstract ISimplePropertyListener getListener();

    protected abstract EStructuralFeature getFeature();

    protected abstract IProperty getOwner();

    public static abstract class EMFListPropertyListener
    extends EMFPropertyListener {
        @Override
        public void notifyChanged(Notification msg) {
            if (this.getFeature() == msg.getFeature() && !msg.isTouch()) {
                ListDiff diff;
                switch (msg.getEventType()) {
                    case 3: {
                        diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)msg.getPosition(), (boolean)true, (Object)msg.getNewValue()));
                        break;
                    }
                    case 5: {
                        Collection newValues = (Collection)msg.getNewValue();
                        ListDiffEntry[] listDiffEntries = new ListDiffEntry[newValues.size()];
                        int position = msg.getPosition();
                        int index = 0;
                        for (Object newValue : newValues) {
                            listDiffEntries[index++] = Diffs.createListDiffEntry((int)position++, (boolean)true, newValue);
                        }
                        diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                        break;
                    }
                    case 4: {
                        diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)msg.getPosition(), (boolean)false, (Object)msg.getOldValue()));
                        break;
                    }
                    case 6: {
                        Collection oldValues = (Collection)msg.getOldValue();
                        ListDiffEntry[] listDiffEntries = new ListDiffEntry[oldValues.size()];
                        int[] positions = (int[])msg.getNewValue();
                        if (positions == null) {
                            int index = 0;
                            for (Object oldValue : oldValues) {
                                listDiffEntries[index] = Diffs.createListDiffEntry((int)0, (boolean)false, oldValue);
                                ++index;
                            }
                        } else {
                            int index = 0;
                            for (Object oldValue : oldValues) {
                                listDiffEntries[index] = Diffs.createListDiffEntry((int)(positions[index] - index), (boolean)false, oldValue);
                                ++index;
                            }
                        }
                        diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                        break;
                    }
                    case 1: 
                    case 9: {
                        int pos = msg.getPosition();
                        Object newValue = msg.getNewValue();
                        Object oldValue = msg.getOldValue();
                        if (pos == -1) {
                            if (newValue == null) {
                                if (oldValue != null) {
                                    diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)0, (boolean)false, (Object)oldValue));
                                    break;
                                }
                                return;
                            }
                            if (oldValue == null) {
                                diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)0, (boolean)true, (Object)newValue));
                                break;
                            }
                            pos = 0;
                        }
                        ListDiffEntry[] listDiffEntries = new ListDiffEntry[]{Diffs.createListDiffEntry((int)pos, (boolean)false, (Object)oldValue), Diffs.createListDiffEntry((int)pos, (boolean)true, (Object)newValue)};
                        diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                        break;
                    }
                    case 7: {
                        Object movedValue = msg.getNewValue();
                        ListDiffEntry[] listDiffEntries = new ListDiffEntry[]{Diffs.createListDiffEntry((int)((Integer)msg.getOldValue()), (boolean)false, (Object)movedValue), Diffs.createListDiffEntry((int)msg.getPosition(), (boolean)true, (Object)movedValue)};
                        diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                        break;
                    }
                    case 2: {
                        return;
                    }
                    default: {
                        throw new RuntimeException("unhandled case");
                    }
                }
                this.getListener().handleEvent(new SimplePropertyEvent(SimplePropertyEvent.CHANGE, msg.getNotifier(), this.getOwner(), (IDiff)diff));
            }
        }
    }

    public static abstract class EMFMapPropertyListener
    extends EMFPropertyListener {
        @Override
        public void addTo(Object source) {
            super.addTo(source);
            if (source != null) {
                EMap map = (EMap)((EObject)source).eGet(this.getFeature());
                for (Map.Entry entry : map) {
                    ((Notifier)entry).eAdapters().add((Object)this);
                }
            }
        }

        @Override
        public void removeFrom(Object source) {
            if (source != null) {
                EMap map = (EMap)((EObject)source).eGet(this.getFeature());
                for (Map.Entry entry : map) {
                    ((Notifier)entry).eAdapters().remove((Object)this);
                }
            }
            super.removeFrom(source);
        }

        @Override
        public void notifyChanged(Notification msg) {
            if (msg.isTouch()) {
                return;
            }
            if (this.getFeature() == msg.getFeature()) {
                MapDiff diff;
                switch (msg.getEventType()) {
                    case 3: {
                        Map.Entry entry = (Map.Entry)msg.getNewValue();
                        ((EObject)entry).eAdapters().add((Object)this);
                        diff = Diffs.createMapDiffSingleAdd(entry.getKey(), entry.getValue());
                        break;
                    }
                    case 5: {
                        Collection newEntries = (Collection)msg.getNewValue();
                        HashMap newValues = new HashMap();
                        for (Map.Entry entry : newEntries) {
                            ((EObject)entry).eAdapters().add((Object)this);
                            newValues.put(entry.getKey(), entry.getValue());
                        }
                        diff = Diffs.createMapDiff(newValues.keySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), newValues);
                        break;
                    }
                    case 4: {
                        Map.Entry entry = (Map.Entry)msg.getOldValue();
                        ((EObject)entry).eAdapters().remove((Object)this);
                        diff = Diffs.createMapDiffSingleRemove(entry.getKey(), entry.getValue());
                        break;
                    }
                    case 6: {
                        Collection oldEntries = (Collection)msg.getOldValue();
                        HashMap oldValues = new HashMap();
                        for (Map.Entry entry : oldEntries) {
                            ((EObject)entry).eAdapters().remove((Object)this);
                            oldValues.put(entry.getKey(), entry.getValue());
                        }
                        diff = Diffs.createMapDiff(Collections.emptySet(), oldValues.keySet(), Collections.emptySet(), oldValues, Collections.emptyMap());
                        break;
                    }
                    case 1: 
                    case 9: {
                        Map.Entry oldEntry = (Map.Entry)msg.getOldValue();
                        ((EObject)oldEntry).eAdapters().remove((Object)this);
                        HashMap oldValues = new HashMap();
                        oldValues.put(oldEntry.getKey(), oldEntry.getValue());
                        Map.Entry newEntry = (Map.Entry)msg.getNewValue();
                        ((EObject)newEntry).eAdapters().add((Object)this);
                        HashMap newValues = new HashMap();
                        newValues.put(newEntry.getKey(), newEntry.getValue());
                        diff = Diffs.createMapDiff(newValues.keySet(), oldValues.keySet(), Collections.emptySet(), oldValues, newValues);
                        break;
                    }
                    case 2: 
                    case 7: {
                        return;
                    }
                    default: {
                        throw new RuntimeException("unhandled case");
                    }
                }
                this.getListener().handleEvent(new SimplePropertyEvent(SimplePropertyEvent.CHANGE, msg.getNotifier(), this.getOwner(), (IDiff)diff));
            } else if (((EClass)this.getFeature().getEType()).getEStructuralFeature("value") == msg.getFeature()) {
                Object key = ((Map.Entry)msg.getNotifier()).getKey();
                MapDiff diff = Diffs.createMapDiffSingleChange(key, (Object)msg.getOldValue(), (Object)msg.getNewValue());
                this.getListener().handleEvent(new SimplePropertyEvent(SimplePropertyEvent.CHANGE, msg.getNotifier(), this.getOwner(), (IDiff)diff));
            }
        }
    }

    public static abstract class EMFSetPropertyListener
    extends EMFPropertyListener {
        @Override
        public void notifyChanged(Notification msg) {
            if (this.getFeature() == msg.getFeature() && !msg.isTouch()) {
                SetDiff diff;
                switch (msg.getEventType()) {
                    case 3: {
                        diff = Diffs.createSetDiff(Collections.singleton(msg.getNewValue()), Collections.emptySet());
                        break;
                    }
                    case 5: {
                        Collection newValues = (Collection)msg.getNewValue();
                        diff = Diffs.createSetDiff(new HashSet(newValues), Collections.emptySet());
                        break;
                    }
                    case 4: {
                        diff = Diffs.createSetDiff(Collections.emptySet(), Collections.singleton(msg.getOldValue()));
                        break;
                    }
                    case 6: {
                        Collection oldValues = (Collection)msg.getOldValue();
                        diff = Diffs.createSetDiff(Collections.emptySet(), new HashSet(oldValues));
                        break;
                    }
                    case 1: 
                    case 9: {
                        diff = Diffs.createSetDiff(Collections.singleton(msg.getNewValue()), Collections.singleton(msg.getOldValue()));
                        break;
                    }
                    case 2: 
                    case 7: {
                        return;
                    }
                    default: {
                        throw new RuntimeException("unhandled case");
                    }
                }
                this.getListener().handleEvent(new SimplePropertyEvent(SimplePropertyEvent.CHANGE, msg.getNotifier(), this.getOwner(), (IDiff)diff));
            }
        }
    }

    public static abstract class EMFValuePropertyListener
    extends EMFPropertyListener {
        @Override
        public void notifyChanged(Notification msg) {
            if (this.getFeature() == msg.getFeature() && !msg.isTouch()) {
                this.getListener().handleEvent(new SimplePropertyEvent(SimplePropertyEvent.CHANGE, msg.getNotifier(), this.getOwner(), (IDiff)Diffs.createValueDiff((Object)msg.getOldValue(), (Object)msg.getNewValue())));
            }
        }
    }
}

