/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.persistence;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaManagedType;
import org.eclipse.jpt.jpa.core.context.java.JavaManagedTypeDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaPersistentTypeDefinition;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceXmlContextModel;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericClassRef
extends AbstractPersistenceXmlContextModel<PersistenceUnit>
implements ClassRef,
JavaPersistentType.Parent {
    protected final XmlJavaClassRef xmlJavaClassRef;
    protected String className;
    protected JavaManagedType javaManagedType;
    protected JavaResourceAbstractType resourceType;

    public GenericClassRef(PersistenceUnit parent, XmlJavaClassRef xmlJavaClassRef) {
        super(parent);
        this.xmlJavaClassRef = xmlJavaClassRef;
        this.className = xmlJavaClassRef.getJavaClass();
        this.initializeJavaManagedType(this.resolveJavaResourceType());
    }

    public GenericClassRef(PersistenceUnit parent, JavaResourceAbstractType resourceType) {
        super(parent);
        this.xmlJavaClassRef = null;
        this.className = resourceType.getTypeBinding().getQualifiedName();
        this.initializeJavaManagedType(resourceType);
    }

    protected void initializeJavaManagedType(JavaResourceAbstractType jrat) {
        this.resourceType = jrat;
        if (this.resourceType != null && this.resourceType.getAstNodeType() == JavaResourceAnnotatedElement.AstNodeType.TYPE) {
            this.javaManagedType = this.buildJavaManagedType((JavaResourceType)this.resourceType);
        }
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        if (this.isNotVirtual()) {
            this.setClassName_(this.xmlJavaClassRef.getJavaClass());
        }
        if (this.javaManagedType != null) {
            this.javaManagedType.synchronizeWithResourceModel(monitor);
        }
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.updateJavaManagedType(monitor);
    }

    @Override
    public void addRootStructureNodesTo(JpaFile jpaFile, Collection<JpaStructureNode> rootStructureNodes) {
        JavaPersistentType javaPersistentType = this.getJavaPersistentType();
        if (javaPersistentType != null) {
            javaPersistentType.addRootStructureNodesTo(jpaFile, rootStructureNodes);
        }
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void setClassName(String className) {
        if (this.isVirtual()) {
            throw new IllegalStateException("The name of a virtual class ref cannot be changed: " + String.valueOf(this));
        }
        this.setClassName_(className);
        this.xmlJavaClassRef.setJavaClass(className);
    }

    protected void setClassName_(String className) {
        String old = this.className;
        this.className = className;
        this.firePropertyChanged("className", old, className);
    }

    protected String getJavaClassName() {
        return StringTools.isBlank((String)this.className) ? null : this.className.replace('$', '.');
    }

    @Override
    public JavaResourceAbstractType getJavaResourceType() {
        return this.resourceType;
    }

    @Override
    public JavaManagedType getJavaManagedType() {
        return this.javaManagedType;
    }

    protected void setJavaManagedType(JavaManagedType managedType) {
        JavaManagedType old = this.javaManagedType;
        this.javaManagedType = managedType;
        this.firePropertyChanged("javaManagedType", old, managedType);
    }

    protected void updateJavaManagedType(IProgressMonitor monitor) {
        this.resourceType = this.resolveJavaResourceType();
        if (this.resourceType == null || this.resourceType.getAstNodeType() != JavaResourceAnnotatedElement.AstNodeType.TYPE) {
            if (this.javaManagedType != null) {
                this.setJavaManagedType(null);
            }
        } else {
            JavaResourceType jrt = (JavaResourceType)this.resourceType;
            JavaManagedTypeDefinition def = this.getJavaManagedTypeDefinition(jrt);
            if (this.javaManagedType == null) {
                this.setJavaManagedType(this.buildJavaManagedType(jrt, def));
            } else if (this.javaManagedType.getJavaResourceType() == jrt && this.javaManagedType.getManagedTypeType() == def.getManagedTypeType()) {
                this.javaManagedType.update(monitor);
            } else {
                this.setJavaManagedType(this.buildJavaManagedType(jrt, def));
            }
        }
    }

    @Override
    public JavaPersistentType getJavaPersistentType() {
        return this.javaManagedType == null ? null : (this.javaManagedType.getManagedTypeType() == PersistentType.class ? (JavaPersistentType)this.javaManagedType : null);
    }

    protected JavaResourceAbstractType resolveJavaResourceType() {
        String javaClassName = this.getJavaClassName();
        return javaClassName == null ? null : this.getJpaProject().getJavaResourceType(javaClassName);
    }

    protected JavaManagedType buildJavaManagedType(JavaResourceType jrt) {
        return this.buildJavaManagedType(jrt, this.getJavaManagedTypeDefinition(jrt));
    }

    protected JavaManagedType buildJavaManagedType(JavaResourceType jrt, JavaManagedTypeDefinition managedTypeDefinition) {
        return managedTypeDefinition.buildContextManagedType(this, jrt, this.getJpaFactory());
    }

    protected Iterable<JavaManagedTypeDefinition> getJavaManagedTypeDefinitions() {
        return this.getJpaPlatform().getJavaManagedTypeDefinitions();
    }

    protected JavaManagedTypeDefinition getJavaManagedTypeDefinition(JavaResourceType jrt) {
        for (JavaManagedTypeDefinition managedTypeDefinition : this.getJavaManagedTypeDefinitions()) {
            if (!jrt.isAnnotatedWithAnyOf(managedTypeDefinition.getAnnotationNames(this.getJpaProject()))) continue;
            return managedTypeDefinition;
        }
        return JavaPersistentTypeDefinition.instance();
    }

    @Override
    public XmlJavaClassRef getXmlClassRef() {
        return this.xmlJavaClassRef;
    }

    protected boolean isFor(IType type) {
        return this.isFor(type.getFullyQualifiedName('.'));
    }

    @Override
    public boolean isFor(String typeName) {
        return ObjectTools.equals((Object)typeName, (Object)this.getJavaClassName());
    }

    protected boolean isInPackage(IPackageFragment packageFragment) {
        return ObjectTools.equals((Object)this.getPackageName(), (Object)packageFragment.getElementName());
    }

    protected String getPackageName() {
        int lastPeriod = this.className.lastIndexOf(46);
        return lastPeriod == -1 ? null : this.className.substring(0, lastPeriod);
    }

    @Override
    public boolean isVirtual() {
        return this.xmlJavaClassRef == null;
    }

    protected boolean isNotVirtual() {
        return !this.isVirtual();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getJavaClassName());
    }

    @Override
    public JpaStructureNode.ContextType getContextType() {
        return new JpaStructureNode.ContextType(this);
    }

    @Override
    public Class<ClassRef> getStructureType() {
        return ClassRef.class;
    }

    public Iterable<JpaStructureNode> getStructureChildren() {
        return EmptyIterable.instance();
    }

    @Override
    public int getStructureChildrenSize() {
        return 0;
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.isNotVirtual() && this.xmlJavaClassRef.containsOffset(textOffset);
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    @Override
    public TextRange getFullTextRange() {
        return this.isVirtual() ? null : this.xmlJavaClassRef.getFullTextRange();
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.isVirtual() ? null : this.xmlJavaClassRef.getJavaClassTextRange();
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return null;
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getPersistenceUnit().getDefaultAccess();
    }

    @Override
    public void attributeChanged(JavaSpecifiedPersistentAttribute attribute) {
    }

    @Override
    public Iterable<DeleteEdit> createDeleteTypeEdits(IType type) {
        if (this.isVirtual()) {
            throw new IllegalStateException();
        }
        return this.isFor(type) ? IterableTools.singletonIterable((Object)this.createDeleteEdit()) : IterableTools.emptyIterable();
    }

    protected DeleteEdit createDeleteEdit() {
        return this.xmlJavaClassRef.createDeleteEdit();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        if (this.isVirtual()) {
            throw new IllegalStateException();
        }
        return this.isFor(originalType) ? IterableTools.singletonIterable((Object)this.createReplaceEdit(originalType, newName)) : IterableTools.emptyIterable();
    }

    protected ReplaceEdit createReplaceEdit(IType originalType, String newName) {
        return this.xmlJavaClassRef.createRenameEdit(originalType, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        if (this.isVirtual()) {
            throw new IllegalStateException();
        }
        return this.isFor(originalType) ? IterableTools.singletonIterable((Object)this.createRenamePackageEdit(newPackage.getElementName())) : IterableTools.emptyIterable();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        if (this.isVirtual()) {
            throw new IllegalStateException();
        }
        return this.isInPackage(originalPackage) ? IterableTools.singletonIterable((Object)this.createRenamePackageEdit(newName)) : IterableTools.emptyIterable();
    }

    protected ReplaceEdit createRenamePackageEdit(String newName) {
        return this.xmlJavaClassRef.createRenamePackageEdit(newName);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (StringTools.isBlank((String)this.className)) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.PERSISTENCE_UNIT_UNSPECIFIED_CLASS));
            return;
        }
        if (this.resourceType == null) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.PERSISTENCE_UNIT_NONEXISTENT_CLASS, this.getJavaClassName()));
            return;
        }
        if (this.isNotVirtual()) {
            if (this.resourceType.getAstNodeType() == JavaResourceAnnotatedElement.AstNodeType.ENUM) {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.PERSISTENCE_UNIT_LISTED_CLASS_IS_AN_ENUM, this.getJavaClassName()));
                return;
            }
            if (this.resourceType.getAstNodeType() == JavaResourceAnnotatedElement.AstNodeType.TYPE && this.resourceType.getTypeBinding().isInterface()) {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.PERSISTENCE_UNIT_LISTED_CLASS_IS_AN_INTERFACE, this.getJavaClassName()));
                return;
            }
        }
        if (this.javaManagedType == null) {
            return;
        }
        boolean validateJavaManagedType = true;
        for (MappingFileRef mappingFileRef : this.getPersistenceUnit().getMappingFileRefsContaining(this.getJavaClassName())) {
            validateJavaManagedType = false;
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.PERSISTENCE_UNIT_REDUNDANT_CLASS, this.getJavaClassName(), mappingFileRef.getFileName()));
        }
        if (validateJavaManagedType) {
            this.validateJavaManagedType(messages, reporter);
        }
    }

    protected void validateJavaManagedType(List<IMessage> messages, IReporter reporter) {
        try {
            this.javaManagedType.validate(messages, reporter);
        }
        catch (Throwable t) {
            JptJpaCorePlugin.instance().logError(t);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlValidationTextRange();
        return textRange != null ? textRange : this.getPersistenceUnit().getValidationTextRange();
    }

    protected TextRange getXmlValidationTextRange() {
        return this.isVirtual() ? null : this.xmlJavaClassRef.getJavaClassTextRange();
    }
}

