/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.infoviews;

import java.io.IOException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.wst.jsdt.core.ICodeAssist;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.infoviews.AbstractInfoView;
import org.eclipse.wst.jsdt.internal.ui.infoviews.InfoViewMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.text.JavaCodeReader;
import org.eclipse.wst.jsdt.internal.ui.text.SimpleJavaSourceViewerConfiguration;
import org.eclipse.wst.jsdt.ui.actions.OpenAction;
import org.eclipse.wst.jsdt.ui.text.JavaScriptSourceViewerConfiguration;

public class SourceView
extends AbstractInfoView
implements IMenuListener {
    private static final String SYMBOLIC_FONT_NAME = "org.eclipse.wst.jsdt.ui.editors.textfont";
    private SourceViewer fViewer;
    private JavaScriptSourceViewerConfiguration fViewerConfiguration;
    private IPropertyChangeListener fFontPropertyChangeListener = new FontPropertyChangeListener();
    private IPropertyChangeListener fPropertyChangeListener = new PropertyChangeListener();
    private OpenAction fOpen;
    private int fCommentLineCount;
    private SelectAllAction fSelectAllAction;
    private IJavaScriptElement fLastOpenedElement;

    @Override
    protected void internalCreatePartControl(Composite parent) {
        IPreferenceStore store = JavaScriptPlugin.getDefault().getCombinedPreferenceStore();
        this.fViewer = new JavaSourceViewer(parent, null, null, false, 768, store);
        this.fViewerConfiguration = new SimpleJavaSourceViewerConfiguration(JavaScriptPlugin.getDefault().getJavaTextTools().getColorManager(), store, null, "___java_partitioning", false);
        this.fViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
        this.fViewer.setEditable(false);
        this.setViewerFont();
        JFaceResources.getFontRegistry().addListener(this.fFontPropertyChangeListener);
        store.addPropertyChangeListener(this.fPropertyChangeListener);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.fSelectAllAction = new SelectAllAction((TextViewer)this.fViewer);
        this.fOpen = new OpenAction((IWorkbenchSite)this.getViewSite()){

            @Override
            public ISelection getSelection() {
                return SourceView.this.convertToJavaElementSelection(SourceView.this.fViewer.getSelection());
            }

            @Override
            public void run(IStructuredSelection selection) {
                if (selection.isEmpty()) {
                    this.getShell().getDisplay().beep();
                    return;
                }
                super.run(selection);
            }

            @Override
            public Object getElementToOpen(Object object) throws JavaScriptModelException {
                if (object instanceof IJavaScriptElement) {
                    SourceView.this.fLastOpenedElement = (IJavaScriptElement)object;
                } else {
                    SourceView.this.fLastOpenedElement = null;
                }
                return super.getElementToOpen(object);
            }

            @Override
            public void run(Object[] elements) {
                SourceView.this.stopListeningForSelectionChanges();
                super.run(elements);
                SourceView.this.startListeningForSelectionChanges();
            }
        };
    }

    @Override
    protected IAction getSelectAllAction() {
        return this.fSelectAllAction;
    }

    @Override
    protected void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.Open", (IAction)this.fOpen);
        this.fOpen.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.editor");
    }

    @Override
    protected Control getControl() {
        return this.fViewer.getControl();
    }

    @Override
    public void menuAboutToShow(IMenuManager menu) {
        super.menuAboutToShow(menu);
        menu.appendToGroup("group.open", (IAction)this.fOpen);
    }

    @Override
    protected void setForeground(Color color) {
        this.fViewer.getTextWidget().setForeground(color);
    }

    @Override
    protected void setBackground(Color color) {
        this.fViewer.getTextWidget().setBackground(color);
    }

    @Override
    protected String getBackgroundColorKey() {
        return "org.eclipse.wst.jsdt.ui.DeclarationView.backgroundColor";
    }

    private IStructuredSelection convertToJavaElementSelection(ISelection selection) {
        if (!(selection instanceof ITextSelection) || !(this.fCurrentViewInput instanceof ISourceReference)) {
            return StructuredSelection.EMPTY;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        IJavaScriptElement codeAssist = this.fCurrentViewInput.getAncestor(5);
        if (codeAssist == null) {
            codeAssist = this.fCurrentViewInput.getAncestor(6);
        }
        if (codeAssist instanceof ICodeAssist) {
            IJavaScriptElement[] elements = null;
            try {
                ISourceRange range = ((ISourceReference)this.fCurrentViewInput).getSourceRange();
                elements = ((ICodeAssist)codeAssist).codeSelect(range.getOffset() + this.getOffsetInUnclippedDocument(textSelection), textSelection.getLength());
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return StructuredSelection.EMPTY;
            }
            if (elements != null && elements.length > 0) {
                return new StructuredSelection((Object)elements[0]);
            }
            return StructuredSelection.EMPTY;
        }
        return StructuredSelection.EMPTY;
    }

    private int getOffsetInUnclippedDocument(ITextSelection textSelection) {
        Document unclippedDocument = null;
        try {
            unclippedDocument = new Document(((ISourceReference)this.fCurrentViewInput).getSource());
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return -1;
        }
        IDocument clippedDoc = (IDocument)this.fViewer.getInput();
        try {
            IRegion unclippedLineInfo = unclippedDocument.getLineInformation(this.fCommentLineCount + textSelection.getStartLine());
            IRegion clippedLineInfo = clippedDoc.getLineInformation(textSelection.getStartLine());
            int removedIndentation = unclippedLineInfo.getLength() - clippedLineInfo.getLength();
            int relativeLineOffset = textSelection.getOffset() - clippedLineInfo.getOffset();
            return unclippedLineInfo.getOffset() + removedIndentation + relativeLineOffset;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    @Override
    protected void internalDispose() {
        this.fViewer = null;
        this.fViewerConfiguration = null;
        JFaceResources.getFontRegistry().removeListener(this.fFontPropertyChangeListener);
        JavaScriptPlugin.getDefault().getCombinedPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
    }

    public void setFocus() {
        this.fViewer.getTextWidget().setFocus();
    }

    @Override
    protected Object computeInput(Object input) {
        boolean firstCharNotWhitespace;
        String source;
        if (this.fViewer == null || !(input instanceof ISourceReference)) {
            return null;
        }
        ISourceReference sourceRef = (ISourceReference)input;
        if (this.fLastOpenedElement != null && input instanceof IJavaScriptElement && ((IJavaScriptElement)input).getHandleIdentifier().equals(this.fLastOpenedElement.getHandleIdentifier())) {
            this.fLastOpenedElement = null;
            return null;
        }
        this.fLastOpenedElement = null;
        try {
            source = sourceRef.getSource();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return "";
        }
        if (source == null) {
            return "";
        }
        source = this.removeLeadingComments(source);
        String delim = StubUtility.getLineDelimiterUsed((IJavaScriptElement)input);
        String[] sourceLines = Strings.convertIntoLines(source);
        if (sourceLines == null || sourceLines.length == 0) {
            return "";
        }
        String firstLine = sourceLines[0];
        boolean bl = firstCharNotWhitespace = firstLine != null && firstLine.length() > 0 && !Character.isWhitespace(firstLine.charAt(0));
        if (firstCharNotWhitespace) {
            sourceLines[0] = "";
        }
        IJavaScriptProject project = input instanceof IJavaScriptElement ? ((IJavaScriptElement)input).getJavaScriptProject() : null;
        Strings.trimIndentation(sourceLines, project);
        if (firstCharNotWhitespace) {
            sourceLines[0] = firstLine;
        }
        return Strings.concatenate(sourceLines, delim);
    }

    @Override
    protected void setInput(Object input) {
        if (input instanceof IDocument) {
            this.fViewer.setInput(input);
        } else if (input == null) {
            this.fViewer.setInput((Object)new Document(""));
        } else {
            Document document = new Document(input.toString());
            JavaScriptPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
            this.fViewer.setInput((Object)document);
        }
    }

    private String removeLeadingComments(String source) {
        int i;
        Document document;
        block18: {
            JavaCodeReader reader = new JavaCodeReader();
            document = new Document(source);
            try {
                try {
                    reader.configureForwardReader((IDocument)document, 0, document.getLength(), true, false);
                    int c = reader.read();
                    while (c != -1 && (c == 13 || c == 10 || c == 9)) {
                        c = reader.read();
                    }
                    i = reader.getOffset();
                    reader.close();
                }
                catch (IOException iOException) {
                    i = 0;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block18;
                    }
                    catch (IOException ex) {
                        JavaScriptPlugin.log(ex);
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ex) {
                    JavaScriptPlugin.log(ex);
                }
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                JavaScriptPlugin.log(ex);
            }
        }
        try {
            this.fCommentLineCount = document.getLineOfOffset(i);
        }
        catch (BadLocationException badLocationException) {
            this.fCommentLineCount = 0;
        }
        if (i < 0) {
            return source;
        }
        return source.substring(i);
    }

    private void setViewerFont() {
        Font font = JFaceResources.getFont((String)SYMBOLIC_FONT_NAME);
        if (this.fViewer.getDocument() != null) {
            Point selection = this.fViewer.getSelectedRange();
            int topIndex = this.fViewer.getTopIndex();
            StyledText styledText = this.fViewer.getTextWidget();
            Control parent = this.fViewer.getControl();
            parent.setRedraw(false);
            styledText.setFont(font);
            this.fViewer.setSelectedRange(selection.x, selection.y);
            this.fViewer.setTopIndex(topIndex);
            if (parent instanceof Composite) {
                Composite composite = (Composite)parent;
                composite.layout(true);
            }
            parent.setRedraw(true);
        } else {
            StyledText styledText = this.fViewer.getTextWidget();
            styledText.setFont(font);
        }
    }

    @Override
    protected String getHelpContextId() {
        return "org.eclipse.wst.jsdt.ui.source_view_context";
    }

    class FontPropertyChangeListener
    implements IPropertyChangeListener {
        FontPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (SourceView.this.fViewer == null) {
                return;
            }
            String property = event.getProperty();
            if (SourceView.SYMBOLIC_FONT_NAME.equals(property)) {
                SourceView.this.setViewerFont();
            }
        }
    }

    class PropertyChangeListener
    implements IPropertyChangeListener {
        PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (SourceView.this.fViewer == null) {
                return;
            }
            if (SourceView.this.fViewerConfiguration.affectsTextPresentation(event)) {
                SourceView.this.fViewerConfiguration.handlePropertyChangeEvent(event);
                SourceView.this.fViewer.invalidateTextPresentation();
            }
        }
    }

    private static class SelectAllAction
    extends Action {
        private TextViewer fTextViewer;

        public SelectAllAction(TextViewer textViewer) {
            super("selectAll");
            Assert.isNotNull((Object)textViewer);
            this.fTextViewer = textViewer;
            this.setText(InfoViewMessages.SelectAllAction_label);
            this.setToolTipText(InfoViewMessages.SelectAllAction_tooltip);
            this.setDescription(InfoViewMessages.SelectAllAction_description);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IAbstractTextEditorHelpContextIds.SELECT_ALL_ACTION);
        }

        public void run() {
            this.fTextViewer.doOperation(7);
        }
    }
}

