/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.basis.graph.AbstractDirectedEdgePath;
import org.eclipse.set.basis.graph.Digraphs;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.session.SessionService;
import org.eclipse.set.feature.table.PlanPro2TableTransformationService;
import org.eclipse.set.feature.table.internal.EdgeToPointsCacheProxy;
import org.eclipse.set.feature.table.internal.TableServiceImpl;
import org.eclipse.set.services.table.TableService;
import org.eclipse.set.utils.table.TableInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(service={IContextFunction.class, EventHandler.class}, property={"service.context.key:String=org.eclipse.set.services.table.TableService", "event.topics=modelsession/change/model", "event.topics=modelsession/loaded/compare"})
public class TableServiceContextFunction
extends ContextFunction
implements EventHandler {
    @Reference
    SessionService sessionService;
    private final Map<TableInfo, PlanPro2TableTransformationService> modelServiceMap = new ConcurrentHashMap<TableInfo, PlanPro2TableTransformationService>();
    private TableServiceImpl tableService;

    public static TableInfo getTableInfo(Map<String, Object> properties) throws IllegalAccessException {
        Object idObject = properties.get("table.shortcut");
        Object categoryObject = properties.get("table.category");
        if (idObject != null && categoryObject != null) {
            return new TableInfo(categoryObject.toString(), idObject.toString());
        }
        throw new IllegalAccessException("table.shortcut or table.category missing in properties");
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addModelService(PlanPro2TableTransformationService service, Map<String, Object> properties) throws IllegalAccessException {
        TableInfo tableInfo = TableServiceContextFunction.getTableInfo(properties);
        if (this.tableService != null) {
            this.tableService.addModelService(service, properties);
        } else {
            this.modelServiceMap.put(tableInfo, service);
        }
    }

    public Object compute(IEclipseContext context, String contextKey) {
        this.tableService = (TableServiceImpl)ContextInjectionFactory.make(TableServiceImpl.class, (IEclipseContext)context);
        this.modelServiceMap.keySet().forEach(tableInfo -> this.tableService.addModelServiceByInfo((TableInfo)tableInfo, this.modelServiceMap.get(tableInfo)));
        MApplication application = (MApplication)context.get(MApplication.class);
        IEclipseContext applicationContext = application.getContext();
        applicationContext.set(TableService.class, (Object)this.tableService);
        return this.tableService;
    }

    public void removeModelService(PlanPro2TableTransformationService service, Map<String, Object> properties) throws IllegalAccessException {
        TableInfo tableInfo = TableServiceContextFunction.getTableInfo(properties);
        if (this.tableService != null) {
            this.tableService.removeModelService(properties);
        } else {
            this.modelServiceMap.remove(tableInfo);
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("modelsession/change/model") || event.getTopic().equals("modelsession/loaded/compare")) {
            AbstractDirectedEdgePath.setEdgeToPointsCacheSupplier(schnittstelle -> EdgeToPointsCacheProxy.getCacheInstance(schnittstelle, Services.getCacheService()));
            Digraphs.setEdgeToSubPathCacheSupplier(schnitstelle -> Services.getCacheService().getCache(schnitstelle, "toolbox.cache.directed-edge-to-subpath"));
        }
        if (event.getTopic().equals("modelsession/close")) {
            ToolboxFileRole closeSession = (ToolboxFileRole)event.getProperty("org.eclipse.e4.data");
            IModelSession loadedSession = this.sessionService.getLoadedSession(closeSession);
            EdgeToPointsCacheProxy.clearCacheInstance(loadedSession.getPlanProSchnittstelle());
        }
    }
}

