/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.InfiniteExpansionException;
import org.apfloat.RoundingHelper;
import org.apfloat.spi.Util;

class HypergeometricHelper {
    private long targetPrecision;
    private long workingPrecision;
    private int radix;
    private Apcomplex[] a;
    private Apcomplex[] b;
    private Apcomplex z;
    private Apint one;
    private Apint zero;

    private HypergeometricHelper(Apcomplex[] a, Apcomplex[] b, Apcomplex z) {
        this.a = a;
        this.b = b;
        this.z = z;
        this.workingPrecision = this.targetPrecision = HypergeometricHelper.precision(a, b, z);
        this.radix = z.radix();
        this.one = Apint.ONES[this.radix];
        this.zero = Apint.ZEROS[this.radix];
    }

    public static Apcomplex hypergeometricPFQ(Apcomplex[] a, Apcomplex[] b, Apcomplex z) {
        return new HypergeometricHelper(a, b, z).hypergeometricPFQ();
    }

    private Apcomplex hypergeometricPFQ() throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex result = this.checkResult();
        if (result != null) {
            return result;
        }
        ArrayList<Apcomplex> bList = new ArrayList<Apcomplex>(Arrays.asList(this.b));
        this.a = (Apcomplex[])Arrays.stream(this.a).filter(z -> !bList.remove(z)).toArray(Apcomplex[]::new);
        this.b = bList.toArray(new Apcomplex[0]);
        if (this.a.length == 2 && this.b.length == 1) {
            return this.hypergeometric2F1(this.a[0], this.a[1], this.b[0], this.z);
        }
        if ((long)this.a.length > (long)this.b.length + 1L) {
            if (this.z.real().signum() == 0 && this.z.imag().signum() == 0) {
                return new Apfloat(1L, this.targetPrecision, this.radix);
            }
            throw new ArithmeticException("Series does not converge");
        }
        if (this.a.length == 0 && this.b.length == 0) {
            return ApcomplexMath.exp(this.z);
        }
        if (this.a.length == 1 && this.b.length == 0) {
            return ApcomplexMath.pow(this.one.subtract(this.z), this.a[0].negate());
        }
        assert (this.b.length > 0);
        result = this.evaluate(this.a, this.b, this.z);
        return ApfloatHelper.limitPrecision(result, this.targetPrecision);
    }

    private Apcomplex hypergeometric2F1(Apcomplex a, Apcomplex b, Apcomplex c, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex result;
        if (z.equals(this.one)) {
            if (a.real().add(b.real()).subtract(c.real()).signum() >= 0) {
                throw new ArithmeticException("Does not converge");
            }
            Apcomplex s = c.subtract(a);
            Apcomplex t2 = c.subtract(b);
            if (s.isInteger() && s.real().signum() <= 0 || t2.isInteger() && t2.real().signum() <= 0) {
                return this.zero;
            }
            Apcomplex cab = s.subtract(b);
            s = ApfloatHelper.ensurePrecision(s, this.workingPrecision);
            t2 = ApfloatHelper.ensurePrecision(t2, this.workingPrecision);
            cab = ApfloatHelper.ensurePrecision(cab, this.workingPrecision);
            return ApcomplexMath.gamma(c).multiply(ApcomplexMath.gamma(cab)).divide(ApcomplexMath.gamma(s).multiply(ApcomplexMath.gamma(t2)));
        }
        Apcomplex zDoublePrecision = z.precision(ApfloatHelper.getDoublePrecision(this.radix));
        Transformation transformation = Arrays.stream(Transformation.values()).filter(t -> t.isApplicable(z)).min(Comparator.comparing(t -> ApcomplexMath.abs(t.z(zDoublePrecision)))).get();
        if (ApcomplexMath.abs(transformation.z(zDoublePrecision)).doubleValue() > 0.8) {
            result = this.alternative(a, b, c, z);
        } else {
            result = null;
            try {
                result = transformation.value(new Hypergeometric2F1Helper(true));
            }
            catch (RetryException re) {
                this.workingPrecision = Util.ifFinite(this.workingPrecision, this.workingPrecision + re.getPrecisionLoss());
                result = transformation.value(new Hypergeometric2F1Helper(false));
            }
        }
        return ApfloatHelper.limitPrecision(result, this.targetPrecision);
    }

    private static long precision(Apcomplex[] z0, Apcomplex[] z1, Apcomplex z2) {
        Apcomplex[] z = (Apcomplex[])Stream.concat(Stream.concat(Arrays.stream(z0), Arrays.stream(z1)), Stream.of(z2)).toArray(Apcomplex[]::new);
        return HypergeometricHelper.precision(z);
    }

    private static long precision(Apcomplex ... z) {
        return Arrays.stream(z).mapToLong(Apcomplex::precision).min().getAsLong();
    }

    private Apcomplex checkResult() {
        Apfloat minNonPositiveIntegerA = HypergeometricHelper.maxNonPositiveInteger(this.a);
        Apfloat minNonPositiveIntegerB = HypergeometricHelper.maxNonPositiveInteger(this.b);
        if (minNonPositiveIntegerB != null && (minNonPositiveIntegerA == null || minNonPositiveIntegerA.compareTo(minNonPositiveIntegerB) < 0)) {
            throw new ArithmeticException("Division by zero");
        }
        if (this.z.real().signum() == 0 && this.z.imag().signum() == 0) {
            return new Apfloat(1L, this.targetPrecision, this.radix);
        }
        if (this.targetPrecision == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate hypergeometric function to infinite precision");
        }
        if (minNonPositiveIntegerA != null) {
            Apcomplex result = this.evaluate(this.a, this.b, this.z);
            return ApfloatHelper.limitPrecision(result, this.targetPrecision);
        }
        return null;
    }

    public static Apfloat maxNonPositiveInteger(Apcomplex ... a) {
        return Arrays.stream(a).filter(Apcomplex::isInteger).map(Apcomplex::real).filter(x -> x.signum() <= 0).reduce(ApfloatMath::max).orElse(null);
    }

    private Apcomplex evaluate(Apcomplex[] a, Apcomplex[] b, Apcomplex z) {
        Apcomplex s;
        long extraPrecision;
        Apcomplex[] aOrig = (Apcomplex[])a.clone();
        Apcomplex[] bOrig = (Apcomplex[])b.clone();
        Apint minN = ApintMath.max(this.one, Stream.concat(Arrays.stream(a), Arrays.stream(b)).map(Apcomplex::real).reduce(ApfloatMath::min).get().truncate().negate()).add(this.one);
        long precisionLoss = 0L;
        long extendedPrecision = ApfloatHelper.extendPrecision(this.workingPrecision, minN.scale());
        this.ensurePrecision(a, a, extendedPrecision);
        this.ensurePrecision(b, b, extendedPrecision);
        z = ApfloatHelper.ensurePrecision(z, extendedPrecision);
        do {
            Apcomplex t;
            long maxSScale = 1L;
            Apint i = this.zero;
            Apcomplex numerator = this.one;
            Apcomplex denominator = this.one;
            extraPrecision = precisionLoss;
            s = this.one;
            do {
                int j;
                i = i.add(this.one);
                for (j = 0; j < a.length; ++j) {
                    numerator = numerator.multiply(a[j]);
                    a[j] = a[j].add(this.one);
                }
                if (numerator.real().signum() == 0 && numerator.imag().signum() == 0) {
                    return s;
                }
                numerator = numerator.multiply(z);
                for (j = 0; j < b.length; ++j) {
                    denominator = denominator.multiply(b[j]);
                    b[j] = b[j].add(this.one);
                }
                denominator = denominator.multiply(i);
                t = numerator.divide(denominator);
                s = s.add(t);
                maxSScale = Math.max(maxSScale, s.scale());
            } while (i.compareTo(minN) <= 0 || s.real().signum() == 0 && s.imag().signum() == 0 || s.scale() - t.scale() <= this.workingPrecision);
            long l = precisionLoss = s.real().signum() == 0 && s.imag().signum() == 0 ? extendedPrecision : maxSScale - s.scale();
            if (this.workingPrecision - s.precision() > 1L) {
                precisionLoss = Util.ifFinite(precisionLoss, precisionLoss + this.workingPrecision - s.precision());
            }
            if (precisionLoss <= extraPrecision) continue;
            extendedPrecision = Util.ifFinite(this.workingPrecision, this.workingPrecision + precisionLoss);
            this.ensurePrecision(aOrig, a, extendedPrecision);
            this.ensurePrecision(bOrig, b, extendedPrecision);
            z = ApfloatHelper.ensurePrecision(z, extendedPrecision);
        } while (precisionLoss > extraPrecision);
        return s;
    }

    private Apcomplex alternative(Apcomplex a, Apcomplex b, Apcomplex c, Apcomplex z) {
        Apint cRounded;
        long digitLoss;
        if (c.real().signum() <= 0 && (digitLoss = -c.subtract(cRounded = RoundingHelper.roundToInteger(c.real(), RoundingMode.HALF_EVEN).truncate()).scale()) > 0L) {
            this.workingPrecision = Util.ifFinite(this.workingPrecision, this.workingPrecision + digitLoss);
            a = this.ensurePrecision(a);
            b = this.ensurePrecision(b);
            c = this.ensurePrecision(c);
            z = this.ensurePrecision(z);
        }
        Apint two = new Apint(2L, this.radix);
        Apint four = new Apint(4L, this.radix);
        Apint k = this.zero;
        Apcomplex d = this.zero;
        Apcomplex e = this.one;
        Apcomplex f = this.zero;
        Apcomplex z1 = this.ensurePrecision(this.one.subtract(z));
        Apcomplex z12 = two.multiply(z1);
        Apcomplex z2 = this.ensurePrecision(z.subtract(two));
        Apcomplex abz = a.multiply(b).multiply(z);
        Apcomplex c2 = c.divide(two);
        Apcomplex c12 = this.ensurePrecision(c.add(this.one)).divide(two);
        Apcomplex cba = this.ensurePrecision(c.subtract(b).subtract(a));
        assert (c2.real().signum() > 0 || c2.imag().signum() != 0 || !c2.isInteger());
        do {
            Apcomplex kc2 = k.add(c2);
            Apcomplex kakbz = k.add(a).multiply(k.add(b)).multiply(z);
            Apcomplex divisor = this.one.divide(four.multiply(k.add(this.one)).multiply(kc2).multiply(k.add(c12)));
            Apcomplex d1 = kakbz.multiply(e.subtract(k.add(cba).multiply(d).multiply(z).divide(z1))).multiply(divisor);
            Apcomplex e1 = kakbz.multiply(abz.multiply(d).divide(z1).add(k.add(c).multiply(e))).multiply(divisor);
            Apcomplex f1 = f.subtract(d.multiply(k.multiply(cba.multiply(z).add(k.multiply(z2)).subtract(c)).subtract(abz)).divide(kc2.multiply(z12))).add(e);
            d = this.ensurePrecision(d1);
            e = this.ensurePrecision(e1);
            f = this.ensurePrecision(f1);
            k = k.add(this.one);
        } while (d.scale() >= -this.workingPrecision || e.scale() >= -this.workingPrecision);
        return f;
    }

    private Apcomplex ensurePrecision(Apcomplex z) {
        return ApfloatHelper.ensurePrecision(z, this.workingPrecision);
    }

    private void ensurePrecision(Apcomplex[] src, Apcomplex[] dest, long extendedPrecision) {
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = ApfloatHelper.ensurePrecision(src[i], extendedPrecision);
        }
    }

    private static enum Transformation {
        T0{

            @Override
            public boolean isApplicable(Apcomplex z) {
                return true;
            }

            @Override
            public Apcomplex z(Apcomplex z) {
                return z;
            }

            @Override
            public Apcomplex value(Hypergeometric2F1Helper helper) {
                Apcomplex a = helper.a;
                Apcomplex b = helper.b;
                Apcomplex c = helper.c;
                Apcomplex z = helper.z;
                return helper.evaluate(a, b, c, z);
            }
        }
        ,
        T1{

            @Override
            public boolean isApplicable(Apcomplex z) {
                return !z.equals(Apint.ONES[z.radix()]);
            }

            @Override
            public Apcomplex z(Apcomplex z) {
                Apint one = Apint.ONES[z.radix()];
                return z.divide(z.subtract(one));
            }

            @Override
            public Apcomplex value(Hypergeometric2F1Helper helper) {
                Apint one = helper.one;
                Apcomplex a = helper.a;
                Apcomplex b = helper.b;
                Apcomplex c = helper.c;
                Apcomplex z = helper.z;
                Apcomplex z1 = one.subtract(z);
                Apcomplex s = c.subtract(a);
                Apcomplex t = c.subtract(b);
                if (s.isInteger() && s.real().signum() <= 0 && (!t.isInteger() || t.real().signum() > 0 || s.real().compareTo(t.real()) >= 0)) {
                    return ApcomplexMath.pow(z1, b.negate()).multiply(helper.evaluate(s, b, c, this.z(z)));
                }
                return ApcomplexMath.pow(z1, a.negate()).multiply(helper.evaluate(a, t, c, this.z(z)));
            }
        }
        ,
        T2{

            @Override
            public boolean isApplicable(Apcomplex z) {
                return z.real().signum() != 0 || z.imag().signum() != 0;
            }

            @Override
            public Apcomplex z(Apcomplex z) {
                Apint one = Apint.ONES[z.radix()];
                return one.divide(z);
            }

            @Override
            public Apcomplex value(Hypergeometric2F1Helper helper) {
                helper.adjustIntegerAB();
                Apint one = helper.one;
                Apcomplex a = helper.a;
                Apcomplex b = helper.b;
                Apcomplex c = helper.c;
                Apcomplex z = helper.z;
                return helper.transform(b.subtract(a), c, z.negate(), a.negate(), b, c.subtract(a), a, a.subtract(c).add(one), a.subtract(b).add(one), z.negate(), b.negate(), one, one, a, c.subtract(b), b, b.subtract(c).add(one), b.subtract(a).add(one), this.z(z));
            }
        }
        ,
        T3{

            @Override
            public boolean isApplicable(Apcomplex z) {
                return !z.equals(Apint.ONES[z.radix()]);
            }

            @Override
            public Apcomplex z(Apcomplex z) {
                Apint one = Apint.ONES[z.radix()];
                return one.divide(one.subtract(z));
            }

            @Override
            public Apcomplex value(Hypergeometric2F1Helper helper) {
                helper.adjustIntegerAB();
                Apint one = helper.one;
                Apcomplex a = helper.a;
                Apcomplex b = helper.b;
                Apcomplex c = helper.c;
                Apcomplex z = helper.z;
                return helper.transform(b.subtract(a), c, one.subtract(z), a.negate(), b, c.subtract(a), a, c.subtract(b), a.subtract(b).add(one), one.subtract(z), b.negate(), one, one, a, c.subtract(b), b, c.subtract(a), b.subtract(a).add(one), this.z(z));
            }
        }
        ,
        T4{

            @Override
            public boolean isApplicable(Apcomplex z) {
                return true;
            }

            @Override
            public Apcomplex z(Apcomplex z) {
                Apint one = Apint.ONES[z.radix()];
                return one.subtract(z);
            }

            @Override
            public Apcomplex value(Hypergeometric2F1Helper helper) {
                helper.adjustIntegerCAB();
                Apint one = helper.one;
                Apcomplex a = helper.a;
                Apcomplex b = helper.b;
                Apcomplex c = helper.c;
                Apcomplex z = helper.z;
                return helper.transform(c.subtract(b).subtract(a), c, one, one, c.subtract(a), c.subtract(b), a, b, a.add(b).subtract(c).add(one), one.subtract(z), c.subtract(a).subtract(b), one, one, a, b, c.subtract(a), c.subtract(b), c.subtract(a).subtract(b).add(one), this.z(z));
            }
        }
        ,
        T5{

            @Override
            public boolean isApplicable(Apcomplex z) {
                return z.real().signum() != 0 || z.imag().signum() != 0;
            }

            @Override
            public Apcomplex z(Apcomplex z) {
                Apint one = Apint.ONES[z.radix()];
                return one.subtract(one.divide(z));
            }

            @Override
            public Apcomplex value(Hypergeometric2F1Helper helper) {
                helper.adjustIntegerCAB();
                Apint one = helper.one;
                Apcomplex a = helper.a;
                Apcomplex b = helper.b;
                Apcomplex c = helper.c;
                Apcomplex z = helper.z;
                return helper.transform(c.subtract(b).subtract(a), c, z, a.negate(), c.subtract(a), c.subtract(b), a, a.subtract(c).add(one), a.add(b).subtract(c).add(one), one.subtract(z), c.subtract(a).subtract(b), z, a.subtract(c), a, b, c.subtract(a), one.subtract(a), c.subtract(a).subtract(b).add(one), this.z(z));
            }
        };


        public abstract boolean isApplicable(Apcomplex var1);

        public abstract Apcomplex z(Apcomplex var1);

        public abstract Apcomplex value(Hypergeometric2F1Helper var1);
    }

    private class Hypergeometric2F1Helper {
        public Apcomplex a;
        public Apcomplex b;
        public Apcomplex c;
        public Apcomplex z;
        public Apint one;
        private boolean retry;

        public Hypergeometric2F1Helper(boolean retry) {
            this.a = HypergeometricHelper.this.a[0];
            this.b = HypergeometricHelper.this.a[1];
            this.c = HypergeometricHelper.this.b[0];
            this.z = HypergeometricHelper.this.z;
            this.one = HypergeometricHelper.this.one;
            this.retry = retry;
        }

        public void ensurePrecisions() {
            this.a = HypergeometricHelper.this.ensurePrecision(this.a);
            this.b = HypergeometricHelper.this.ensurePrecision(this.b);
            this.c = HypergeometricHelper.this.ensurePrecision(this.c);
            this.z = HypergeometricHelper.this.ensurePrecision(this.z);
        }

        public void adjustIntegerAB() {
            Apcomplex ab = this.a.subtract(this.b);
            if (ab.isInteger()) {
                this.swapLargerAB();
                long digitLoss = HypergeometricHelper.this.workingPrecision;
                HypergeometricHelper.this.workingPrecision = Util.ifFinite(HypergeometricHelper.this.workingPrecision, HypergeometricHelper.this.workingPrecision + digitLoss);
                Apfloat offset = this.offset(-digitLoss);
                this.a = new Apcomplex(this.a.real().precision(Long.MAX_VALUE).add(offset), this.a.imag());
                this.b = new Apcomplex(this.adjustOffset(this.b.real(), offset), this.b.imag());
                this.ensurePrecisions();
            } else {
                Apint abRounded = RoundingHelper.roundToInteger(ab.real(), RoundingMode.HALF_EVEN).truncate();
                long digitLoss = -ab.subtract(abRounded).scale();
                if (digitLoss > 0L) {
                    HypergeometricHelper.this.workingPrecision = Util.ifFinite(HypergeometricHelper.this.workingPrecision, HypergeometricHelper.this.workingPrecision + digitLoss);
                    Apfloat offset = this.offset(-digitLoss);
                    this.a = new Apcomplex(this.adjustOffset(this.a.real(), offset), this.a.imag());
                    this.b = new Apcomplex(this.adjustOffset(this.b.real(), offset), this.b.imag());
                    this.ensurePrecisions();
                }
            }
        }

        public void adjustIntegerCAB() {
            Apcomplex cab = this.c.subtract(this.a).subtract(this.b);
            if (cab.isInteger()) {
                this.swapLargerAB();
                long digitLoss = HypergeometricHelper.this.workingPrecision;
                HypergeometricHelper.this.workingPrecision = Util.ifFinite(HypergeometricHelper.this.workingPrecision, HypergeometricHelper.this.workingPrecision + digitLoss);
                Apfloat offset = this.offset(-digitLoss);
                if (this.c.real().scale() > this.a.real().scale()) {
                    this.c = new Apcomplex(this.c.real().precision(Long.MAX_VALUE).add(offset), this.c.imag());
                    this.a = new Apcomplex(this.adjustOffset(this.a.real(), offset), this.a.imag());
                } else {
                    this.c = new Apcomplex(this.adjustOffset(this.c.real(), offset), this.c.imag());
                    this.a = new Apcomplex(this.a.real().precision(Long.MAX_VALUE).add(offset), this.a.imag());
                }
                this.b = new Apcomplex(this.adjustOffset(this.b.real(), offset), this.b.imag());
                this.ensurePrecisions();
            } else {
                Apint cabRounded = RoundingHelper.roundToInteger(cab.real(), RoundingMode.HALF_EVEN).truncate();
                long digitLoss = -cab.subtract(cabRounded).scale();
                if (digitLoss > 0L) {
                    HypergeometricHelper.this.workingPrecision = Util.ifFinite(HypergeometricHelper.this.workingPrecision, HypergeometricHelper.this.workingPrecision + digitLoss);
                    Apfloat offset = this.offset(-digitLoss);
                    this.a = new Apcomplex(this.adjustOffset(this.a.real(), offset), this.a.imag());
                    this.b = new Apcomplex(this.adjustOffset(this.b.real(), offset), this.b.imag());
                    this.c = new Apcomplex(this.adjustOffset(this.c.real(), offset), this.c.imag());
                    this.ensurePrecisions();
                }
            }
        }

        private void swapLargerAB() {
            if (this.a.real().scale() < this.b.real().scale()) {
                Apcomplex tmp = this.a;
                this.a = this.b;
                this.b = tmp;
            }
        }

        private Apfloat offset(long scale) {
            Apfloat offset = ApfloatMath.scale(new Apfloat("0.1", HypergeometricHelper.this.workingPrecision, HypergeometricHelper.this.radix), scale);
            return offset;
        }

        private Apfloat adjustOffset(Apfloat x, Apfloat offset) {
            if (x.scale() <= offset.scale()) {
                return x;
            }
            return x.precision(Long.MAX_VALUE).add(offset).subtract(offset);
        }

        public Apcomplex transform(Apcomplex s, Apcomplex c, Apcomplex base1, Apcomplex exp1, Apcomplex g1, Apcomplex g2, Apcomplex a1, Apcomplex b1, Apcomplex c1, Apcomplex base2, Apcomplex exp2, Apcomplex base3, Apcomplex exp3, Apcomplex g3, Apcomplex g4, Apcomplex a2, Apcomplex b2, Apcomplex c2, Apcomplex z) {
            long precisionLoss;
            Apcomplex term1 = g1.isInteger() && g1.real().signum() <= 0 || g2.isInteger() && g2.real().signum() <= 0 ? HypergeometricHelper.this.zero : ApcomplexMath.pow(base1, exp1).divide(ApcomplexMath.gamma(g1).multiply(ApcomplexMath.gamma(g2)).multiply(ApcomplexMath.gamma(c1))).multiply(this.evaluate(a1, b1, c1, z));
            Apcomplex term2 = g3.isInteger() && g3.real().signum() <= 0 || g4.isInteger() && g4.real().signum() <= 0 ? HypergeometricHelper.this.zero : ApcomplexMath.pow(base2, exp2).multiply(ApcomplexMath.pow(base3, exp3)).divide(ApcomplexMath.gamma(g3).multiply(ApcomplexMath.gamma(g4)).multiply(ApcomplexMath.gamma(c2))).multiply(this.evaluate(a2, b2, c2, z));
            Apcomplex d = term1.subtract(term2);
            long l = precisionLoss = d.real().signum() == 0 && d.imag().signum() == 0 ? HypergeometricHelper.this.workingPrecision : HypergeometricHelper.this.targetPrecision - d.precision();
            if (this.retry && precisionLoss > 1L) {
                throw new RetryException(precisionLoss);
            }
            Apfloat pi = ApfloatMath.pi(HypergeometricHelper.this.workingPrecision, HypergeometricHelper.this.radix);
            return ApcomplexMath.gamma(c).multiply(pi).divide(ApcomplexMath.sin(pi.multiply(s))).multiply(d);
        }

        private Apcomplex evaluate(Apcomplex a, Apcomplex b, Apcomplex c, Apcomplex z) {
            return HypergeometricHelper.this.evaluate(new Apcomplex[]{a, b}, new Apcomplex[]{c}, z);
        }
    }

    private static class RetryException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private long precisionLoss;

        public RetryException(long precisionLoss) {
            this.precisionLoss = precisionLoss;
        }

        public long getPrecisionLoss() {
            return this.precisionLoss;
        }
    }
}

