/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table;

import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.TablemodelFactory;
import org.eclipse.set.utils.excel.ExcelWorkbookExtension;
import org.eclipse.set.utils.table.GroupBuilder;

public class TableBuilderFromExcel {
    public static void headerBuilder(Sheet sheet, GroupBuilder root, int columnIndex) {
        Optional cell = ExcelWorkbookExtension.getCellAt((Sheet)sheet, (int)1, (int)columnIndex);
        boolean _isEmpty = cell.isEmpty();
        if (_isEmpty) {
            return;
        }
        Cell lastCellofGroup = TableBuilderFromExcel.nestedGroupBuilder(root, cell).get();
        int _columnIndex = lastCellofGroup.getColumnIndex();
        int _plus = _columnIndex + 1;
        TableBuilderFromExcel.headerBuilder(sheet, root, _plus);
    }

    private static Optional<Cell> nestedGroupBuilder(GroupBuilder parent, Optional<Cell> cell) {
        boolean _isEmpty = ExcelWorkbookExtension.getCellStringValue(cell).isEmpty();
        if (_isEmpty) {
            return cell;
        }
        Sheet sheet = cell.get().getSheet();
        Optional columnSpan = ExcelWorkbookExtension.getColumnSpanRangeAt((Cell)cell.get());
        boolean _isPresent = columnSpan.isPresent();
        if (_isPresent) {
            return TableBuilderFromExcel.nestedColumnGroupBuilder(sheet, parent, (CellRangeAddress)columnSpan.get());
        }
        return TableBuilderFromExcel.singleGroupBuilder(parent, cell.get());
    }

    private static Optional<Cell> nestedColumnGroupBuilder(Sheet sheet, GroupBuilder parent, CellRangeAddress columnSpanRange) {
        int firstColumnIndex = columnSpanRange.getFirstColumn();
        int lastColumnIndex = columnSpanRange.getLastColumn();
        int currentRowIndex = columnSpanRange.getFirstRow();
        Optional<Cell> currentCell = ExcelWorkbookExtension.getCellAt((Sheet)sheet, (int)currentRowIndex, (int)firstColumnIndex);
        Optional currentCellValue = ExcelWorkbookExtension.getCellStringValue((Optional)currentCell);
        if (firstColumnIndex == lastColumnIndex || currentCellValue.isEmpty()) {
            return currentCell;
        }
        GroupBuilder currentGroup = parent.addGroup((String)currentCellValue.get());
        boolean _isPresent = currentCell.isPresent();
        if (_isPresent) {
            ColumnDescriptor _groupRoot = currentGroup.getGroupRoot();
            _groupRoot.setHeight((double)TableBuilderFromExcel.getCellHeight(sheet, (Cell)currentCell.get()));
        }
        int i = firstColumnIndex;
        while (i <= lastColumnIndex) {
            int nextRowIndex = currentRowIndex + 1;
            Optional childCell = ExcelWorkbookExtension.getCellAt((Sheet)sheet, (int)nextRowIndex, (int)i);
            currentCell = TableBuilderFromExcel.nestedGroupBuilder(currentGroup, childCell);
            ++i;
        }
        return currentCell;
    }

    private static Optional<Cell> singleGroupBuilder(GroupBuilder parent, Cell cell) {
        boolean _isSingleColumnGroup = TableBuilderFromExcel.isSingleColumnGroup(Optional.of(cell));
        if (_isSingleColumnGroup) {
            int _rowIndex;
            int _plus;
            GroupBuilder singleGroup = parent.addGroup(cell.getStringCellValue());
            Sheet _sheet = cell.getSheet();
            Optional cellAtNextRow = ExcelWorkbookExtension.getCellAt((Sheet)_sheet, (int)(_plus = (_rowIndex = cell.getRowIndex()) + 1), (int)cell.getColumnIndex());
            boolean _isPresent = cellAtNextRow.isPresent();
            if (_isPresent) {
                return TableBuilderFromExcel.singleGroupBuilder(singleGroup, (Cell)cellAtNextRow.get());
            }
        }
        return TableBuilderFromExcel.cellBuild(parent, cell);
    }

    public static boolean isSingleColumnGroup(Optional<Cell> cell) {
        if (cell.isEmpty() && cell.get().getStringCellValue().isEmpty()) {
            return false;
        }
        int lastRowOfSheet = ExcelWorkbookExtension.getHeaderLastRowIndex((Sheet)cell.get().getSheet());
        int _rowIndex = cell.get().getRowIndex();
        int nextRow = _rowIndex + 1;
        if (lastRowOfSheet != cell.get().getRowIndex() && lastRowOfSheet != nextRow) {
            Optional nextRowCell = ExcelWorkbookExtension.getCellAt((Sheet)cell.get().getSheet(), (int)nextRow, (int)cell.get().getColumnIndex());
            return ExcelWorkbookExtension.getCellStringValue((Optional)nextRowCell).isPresent();
        }
        return false;
    }

    private static Optional<Cell> cellBuild(GroupBuilder parent, Cell cell) {
        Optional unitValue;
        boolean _isPresent_1;
        Sheet sheet = cell.getSheet();
        int columnIndex = cell.getColumnIndex();
        Optional columnName = ExcelWorkbookExtension.getCellStringValue((Optional)ExcelWorkbookExtension.getCellAt((Sheet)sheet, (int)0, (int)columnIndex));
        ColumnDescriptor columnDescriptor = TablemodelFactory.eINSTANCE.createColumnDescriptor();
        columnDescriptor.setLabel(cell.getStringCellValue());
        columnDescriptor.setWidth(Float.valueOf(Float.valueOf(ExcelWorkbookExtension.getColumnWidthInCm((Sheet)sheet, (int)columnIndex)).floatValue()));
        columnDescriptor.setHeight((double)TableBuilderFromExcel.getCellHeight(sheet, cell));
        boolean _isPresent = columnName.isPresent();
        if (_isPresent) {
            columnDescriptor.setColumnPosition((String)columnName.get());
        }
        if (_isPresent_1 = (unitValue = ExcelWorkbookExtension.getCellStringValue((Optional)ExcelWorkbookExtension.getCellAt((Sheet)sheet, (int)ExcelWorkbookExtension.getHeaderLastRowIndex((Sheet)sheet), (int)columnIndex))).isPresent()) {
            parent.add(columnDescriptor, (String)unitValue.get());
        } else {
            parent.add(columnDescriptor);
        }
        return Optional.of(cell);
    }

    private static float getCellHeight(Sheet sheet, Cell cell) {
        float cellHeight = ExcelWorkbookExtension.getRowHeightInCm((Sheet)sheet, (int)cell.getRowIndex());
        Optional rowSpan = ExcelWorkbookExtension.getRowSpanRangeAt((Sheet)sheet, (int)cell.getRowIndex(), (int)cell.getColumnIndex());
        boolean _isPresent = rowSpan.isPresent();
        if (_isPresent) {
            int firstRow = ((CellRangeAddress)rowSpan.get()).getFirstRow();
            int lastRow = ((CellRangeAddress)rowSpan.get()).getLastRow();
            int i = firstRow + 1;
            while (i <= lastRow) {
                float _cellHeight = cellHeight;
                float _rowHeightInCm = ExcelWorkbookExtension.getRowHeightInCm((Sheet)sheet, (int)i);
                cellHeight = _cellHeight + _rowHeightInCm;
                ++i;
            }
        }
        return Float.valueOf(cellHeight).floatValue();
    }
}

