/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCS;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSDescription;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSIntro;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSItem;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSModelFactory;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.actions.SimpleActionMessages;
import org.eclipse.pde.internal.ua.ui.wizards.cheatsheet.BaseCSCreationOperation;
import org.eclipse.pde.internal.ui.util.PDELabelUtility;

public class SimpleCSAddStepAction
extends Action {
    private ISimpleCS fCheatsheet;
    private ISimpleCSItem fItem;
    private ISimpleCSIntro fIntro;

    public SimpleCSAddStepAction() {
        this.setText(SimpleActionMessages.SimpleCSAddStepAction_actionText);
    }

    public void setDataObject(ISimpleCSObject csObject) {
        if (csObject.getType() == 0) {
            this.fIntro = null;
            this.fItem = null;
            this.fCheatsheet = (ISimpleCS)csObject;
        } else if (csObject.getType() == 6) {
            this.fIntro = null;
            this.fItem = (ISimpleCSItem)csObject;
            this.fCheatsheet = this.fItem.getSimpleCS();
        } else if (csObject.getType() == 5) {
            this.fIntro = (ISimpleCSIntro)csObject;
            this.fItem = null;
            this.fCheatsheet = this.fIntro.getSimpleCS();
        } else {
            this.fIntro = null;
            this.fItem = null;
            this.fCheatsheet = null;
        }
    }

    public void run() {
        if (this.fCheatsheet == null) {
            return;
        }
        ISimpleCSItem newItem = this.createNewItem();
        this.insertNewItem(newItem);
    }

    private void insertNewItem(ISimpleCSItem newItem) {
        if (this.fIntro != null) {
            this.fCheatsheet.addItem(0, newItem);
        } else if (this.fItem != null) {
            int index = this.fCheatsheet.indexOfItem(this.fItem) + 1;
            this.fCheatsheet.addItem(index, newItem);
        } else {
            this.fCheatsheet.addItem(newItem);
        }
    }

    private ISimpleCSItem createNewItem() {
        ISimpleCSModelFactory factory = this.fCheatsheet.getModel().getFactory();
        ISimpleCSItem item = factory.createSimpleCSItem((ISimpleCSObject)this.fCheatsheet);
        ISimpleCSItem[] items = this.fCheatsheet.getItems();
        String[] itemNames = new String[items.length];
        int i = 0;
        while (i < items.length) {
            itemNames[i] = items[i].getTitle();
            ++i;
        }
        item.setTitle(PDELabelUtility.generateName((String[])itemNames, (String)SimpleActionMessages.SimpleCSAddStepAction_actionLabel));
        ISimpleCSDescription description = factory.createSimpleCSDescription((ISimpleCSObject)item);
        description.setContent(BaseCSCreationOperation.formatTextBold(SimpleActionMessages.SimpleCSAddStepAction_actionDescription));
        item.setDescription(description);
        return item;
    }
}

