/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.report;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.reporting.core.ReportRendererManager;
import org.eclipse.rcptt.ui.report.FolderSelectionDialog;
import org.eclipse.rcptt.ui.report.ReportWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ReportMainPage
extends WizardPage {
    DataBindingContext dbc = new DataBindingContext();
    WritableValue<String> reportName = new WritableValue((Object)"", String.class);
    WritableValue<ReportRendererManager.ReportRenderer> reportFormat = new WritableValue(null, ReportRendererManager.ReportRenderer.class);
    WritableList<ReportRendererManager.ReportRenderer> reports = new WritableList(new ArrayList(), ReportRendererManager.ReportRenderer.class);
    WritableValue<Boolean> generateToWorkspace = new WritableValue((Object)Boolean.TRUE, Boolean.class);
    WritableValue<String> workspaceLocation = new WritableValue((Object)"", String.class);
    WritableValue<String> filesystemLocation = new WritableValue((Object)"", String.class);
    private ReportWizard wizard;
    private String initialWorkspaceLocation;

    protected ReportMainPage(ReportWizard reportWizard, String[] disabled, String initialWorkspaceLocation) {
        super("ReportMainPage", Messages.ReportMainPage_Name, null);
        ReportRendererManager.ReportRenderer[] extensions;
        this.wizard = reportWizard;
        this.setDescription(Messages.ReportMainPage_Description);
        ReportRendererManager.ReportRenderer[] reportRendererArray = extensions = ReportRendererManager.getInstance().getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            ReportRendererManager.ReportRenderer reportRenderer = reportRendererArray[n2];
            String extension = reportRenderer.getExtension();
            boolean found = false;
            if (disabled != null) {
                String[] stringArray = disabled;
                int n3 = disabled.length;
                int n4 = 0;
                while (n4 < n3) {
                    String d = stringArray[n4];
                    if (d.equals(extension)) {
                        found = true;
                        break;
                    }
                    ++n4;
                }
            }
            if (!found) {
                this.reports.add((Object)reportRenderer);
                if (this.reportFormat.getValue() == null) {
                    this.reportFormat.setValue((Object)reportRenderer);
                }
            }
            ++n2;
        }
        this.reportName.setValue((Object)this.wizard.getName());
        this.initialWorkspaceLocation = initialWorkspaceLocation;
    }

    public String getReportName() {
        return (String)this.reportName.getValue();
    }

    public ReportRendererManager.ReportRenderer getRenderer() {
        return (ReportRendererManager.ReportRenderer)this.reportFormat.getValue();
    }

    public boolean isToWorkspace() {
        return (Boolean)this.generateToWorkspace.getValue();
    }

    public String getLocation() {
        if (this.isToWorkspace()) {
            String value = (String)this.workspaceLocation.getValue();
            IDialogSettings ds = this.getDialogSettings();
            if (ds != null) {
                ds.put("report.dialog.workspace.location", value);
            }
            return value;
        }
        return (String)this.filesystemLocation.getValue();
    }

    public void createControl(Composite parent) {
        String loc;
        Composite panel = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(panel);
        Label l = new Label(panel, 0);
        l.setText(Messages.ReportMainPage_NameLabel);
        Text reportName = new Text(panel, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)reportName);
        final ControlDecoration controlDecoration = new ControlDecoration((Control)reportName, 16512);
        controlDecoration.setDescriptionText("");
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        controlDecoration.setImage(fieldDecoration.getImage());
        controlDecoration.hide();
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)reportName), this.reportName);
        this.reportName.addValueChangeListener((IValueChangeListener)new IValueChangeListener<String>(){

            public void handleValueChange(ValueChangeEvent<? extends String> event) {
                String name = (String)event.getObservableValue().getValue();
                if (name.trim().length() == 0) {
                    controlDecoration.show();
                    controlDecoration.showHoverText(Messages.ReportMainPage_EmptyReportNameMsg);
                    ReportMainPage.this.validate();
                    return;
                }
                controlDecoration.hide();
                ReportMainPage.this.validate();
            }
        });
        l = new Label(panel, 0);
        l.setText(Messages.ReportMainPage_FormatLabel);
        Combo reportFormat = new Combo(panel, 2056);
        GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)reportFormat);
        IConverter nameToRenderer = IConverter.create(String.class, ReportRendererManager.ReportRenderer.class, this::convertReport);
        IConverter rendererToName = IConverter.create(ReportRendererManager.ReportRenderer.class, String.class, ReportRendererManager.ReportRenderer::getName);
        this.dbc.bindList((IObservableList)WidgetProperties.items().observe((Widget)reportFormat), this.reports, UpdateListStrategy.create((IConverter)nameToRenderer), UpdateListStrategy.create((IConverter)rendererToName));
        this.dbc.bindValue((IObservableValue)WidgetProperties.comboSelection().observe((Widget)reportFormat), this.reportFormat, UpdateValueStrategy.create((IConverter)nameToRenderer), UpdateValueStrategy.create((IConverter)rendererToName));
        ReportRendererManager.ReportRenderer defaultRenderer = null;
        int i = 0;
        while (i < this.reports.size()) {
            ReportRendererManager.ReportRenderer rr = (ReportRendererManager.ReportRenderer)this.reports.get(i);
            if (rr.getExtension().equals("html")) {
                defaultRenderer = rr;
                break;
            }
            ++i;
        }
        if (defaultRenderer != null) {
            this.reportFormat.setValue(defaultRenderer);
        } else {
            this.reportFormat.setValue((Object)((ReportRendererManager.ReportRenderer)this.reports.get(0)));
        }
        l = new Label(panel, 0);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)l);
        Composite sPanel = new Composite(panel, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(sPanel);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)sPanel);
        l = new Label(sPanel, 0);
        l.setText(Messages.ReportMainPage_OutputLabel);
        l = new Label(sPanel, 258);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)l);
        this.createGenerateWorkspace(panel);
        this.createGenerateToFilesystem(panel);
        this.setControl((Control)panel);
        IDialogSettings ds = this.getDialogSettings();
        if (ds != null && (loc = ds.get("report.dialog.workspace.location")) != null) {
            this.workspaceLocation.setValue((Object)loc);
        }
        if (this.initialWorkspaceLocation != null) {
            this.workspaceLocation.setValue((Object)this.initialWorkspaceLocation);
        }
        this.validate();
    }

    protected boolean validate() {
        String repName = (String)this.reportName.getValue();
        if (repName.trim().length() == 0) {
            this.setPageComplete(false);
            return false;
        }
        boolean generateToWorkspace = (Boolean)this.generateToWorkspace.getValue();
        if (generateToWorkspace) {
            if (!this.isValidWorkspaceLocation()) {
                this.setPageComplete(false);
                return false;
            }
        } else if (!this.isValidFileLocation()) {
            this.setPageComplete(false);
            return false;
        }
        this.setPageComplete(true);
        return true;
    }

    private boolean isValidWorkspaceLocation() {
        String wLoc = (String)this.workspaceLocation.getValue();
        if (wLoc.trim().length() == 0) {
            return false;
        }
        boolean exist = ResourcesPlugin.getWorkspace().getRoot().exists((IPath)new Path(wLoc));
        return exist;
    }

    private boolean isValidFileLocation() {
        String wLoc = (String)this.filesystemLocation.getValue();
        if (wLoc.trim().length() == 0) {
            return false;
        }
        return new File(wLoc).exists();
    }

    private void createGenerateToFilesystem(Composite panel) {
        Button generateToFilesystem = new Button(panel, 16);
        generateToFilesystem.setText(Messages.ReportMainPage_GenerateInFileSystemButton);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)generateToFilesystem);
        Composite sPanelFileSystem = new Composite(panel, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(20, 0, 0, 0).applyTo(sPanelFileSystem);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)sPanelFileSystem);
        Label sFileSystemLabel = new Label(sPanelFileSystem, 0);
        sFileSystemLabel.setText(Messages.ReportMainPage_LocationLabel);
        Text filesystemLocation = new Text(sPanelFileSystem, 2048);
        final ControlDecoration controlDecoration = new ControlDecoration((Control)filesystemLocation, 16512);
        controlDecoration.setDescriptionText("");
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        controlDecoration.setImage(fieldDecoration.getImage());
        controlDecoration.hide();
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)filesystemLocation);
        Button browseFilesystem = new Button(sPanelFileSystem, 8);
        browseFilesystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ReportMainPage.this.getShell());
                dialog.setMessage(Messages.ReportMainPage_SelectLocationDialogText);
                dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().removeFirstSegments(1).toString());
                dialog.setText(Messages.ReportMainPage_SelectLocationDialogText);
                String location = dialog.open();
                if (location != null) {
                    ReportMainPage.this.filesystemLocation.setValue((Object)location);
                }
            }
        });
        browseFilesystem.setText(Messages.ReportMainPage_BrowseButton);
        this.setButtonLayoutData(browseFilesystem);
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)browseFilesystem), this.generateToWorkspace, UpdateValueStrategy.never(), (UpdateValueStrategy)new InverseBooleanConverter());
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)filesystemLocation), this.generateToWorkspace, UpdateValueStrategy.never(), (UpdateValueStrategy)new InverseBooleanConverter());
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)sFileSystemLabel), this.generateToWorkspace, UpdateValueStrategy.never(), (UpdateValueStrategy)new InverseBooleanConverter());
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)filesystemLocation), this.filesystemLocation);
        this.filesystemLocation.addValueChangeListener((IValueChangeListener)new IValueChangeListener<String>(){

            public void handleValueChange(ValueChangeEvent<? extends String> event) {
                if (!ReportMainPage.this.isValidFileLocation()) {
                    controlDecoration.show();
                    controlDecoration.showHoverText(Messages.ReportMainPage_NoOutputLocationMsg);
                    ReportMainPage.this.validate();
                    return;
                }
                controlDecoration.hide();
                ReportMainPage.this.validate();
            }
        });
    }

    private void createGenerateWorkspace(Composite panel) {
        Button generateToWorkspace = new Button(panel, 16);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)generateToWorkspace);
        generateToWorkspace.setText(Messages.ReportMainPage_GenerateInWorkspaceButton);
        Composite sPanelWorkspace = new Composite(panel, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(20, 0, 0, 0).applyTo(sPanelWorkspace);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)sPanelWorkspace);
        Label sWorkspaceLanel = new Label(sPanelWorkspace, 0);
        sWorkspaceLanel.setText(Messages.ReportMainPage_LocationLabel);
        Text workspaceLocation = new Text(sPanelWorkspace, 2048);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)workspaceLocation);
        final ControlDecoration controlDecoration = new ControlDecoration((Control)workspaceLocation, 16512);
        controlDecoration.setDescriptionText("");
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        controlDecoration.setImage(fieldDecoration.getImage());
        controlDecoration.hide();
        Button browseWorkspace = new Button(sPanelWorkspace, 8);
        browseWorkspace.setText(Messages.ReportMainPage_BrowseButton);
        browseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] result;
                FolderSelectionDialog dialog = new FolderSelectionDialog(ReportMainPage.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider()){

                    protected TreeViewer createTreeViewer(Composite parent) {
                        TreeViewer viewer = super.createTreeViewer(parent);
                        viewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

                            public boolean select(Viewer viewer, Object parentElement, Object element) {
                                return !(element instanceof IResource) || ((IResource)element).getType() != 1;
                            }
                        }});
                        return viewer;
                    }
                };
                dialog.setInput(ResourcesPlugin.getWorkspace().getRoot());
                dialog.setAllowMultiple(false);
                dialog.setMessage(Messages.ReportMainPage_SelectLocationDialogText);
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
                    ReportMainPage.this.workspaceLocation.setValue((Object)((IResource)result[0]).getFullPath().toString());
                }
            }
        });
        this.setButtonLayoutData(browseWorkspace);
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)browseWorkspace), this.generateToWorkspace);
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)workspaceLocation), this.generateToWorkspace);
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)sWorkspaceLanel), this.generateToWorkspace);
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)generateToWorkspace), this.generateToWorkspace);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)workspaceLocation), this.workspaceLocation);
        this.workspaceLocation.addValueChangeListener((IValueChangeListener)new IValueChangeListener<String>(){

            public void handleValueChange(ValueChangeEvent<? extends String> event) {
                if (!ReportMainPage.this.isValidWorkspaceLocation()) {
                    controlDecoration.show();
                    controlDecoration.showHoverText(Messages.ReportMainPage_IncorrectLocationMsg);
                    ReportMainPage.this.validate();
                    return;
                }
                controlDecoration.hide();
                ReportMainPage.this.validate();
            }
        });
        this.generateToWorkspace.addValueChangeListener((IValueChangeListener)new IValueChangeListener<Boolean>(){

            public void handleValueChange(ValueChangeEvent<? extends Boolean> event) {
                ReportMainPage.this.validate();
            }
        });
    }

    private ReportRendererManager.ReportRenderer convertReport(String value) {
        int i = 0;
        while (i < this.reports.size()) {
            ReportRendererManager.ReportRenderer ren = (ReportRendererManager.ReportRenderer)this.reports.get(i);
            if (ren.getName().equals(value)) {
                return ren;
            }
            ++i;
        }
        return null;
    }

    public boolean isPageComplete() {
        return super.isPageComplete();
    }

    private final class InverseBooleanConverter
    extends UpdateValueStrategy<Boolean, Boolean> {
        private InverseBooleanConverter() {
        }

        public Boolean convert(Boolean value) {
            return value == false;
        }
    }
}

