/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;

public final class SiriusReferenceFinderCache {
    public static final SiriusReferenceFinderCache INSTANCE = new SiriusReferenceFinderCache();
    private final Map<EObject, Collection<DRepresentationDescriptor>> impactedRepDescriptors = new HashMap<EObject, Collection<DRepresentationDescriptor>>();
    private boolean cacheEnabled;

    private SiriusReferenceFinderCache() {
    }

    public void enable() {
        if (this.cacheEnabled) {
            SiriusPlugin.getDefault().warning(Messages.ReferenceFinderCache_warningAlreadyEnabled, null);
        } else {
            this.cacheEnabled = true;
            this.impactedRepDescriptors.clear();
        }
    }

    public void disable() {
        if (this.cacheEnabled) {
            this.impactedRepDescriptors.clear();
            this.cacheEnabled = false;
        }
    }

    public boolean isEnabled() {
        return this.cacheEnabled;
    }

    public boolean containsKey(EObject key) {
        return this.cacheEnabled && this.impactedRepDescriptors.containsKey(key);
    }

    public Collection<DRepresentationDescriptor> put(EObject key, Collection<DRepresentationDescriptor> dRepresentationDescriptors) {
        Collection<DRepresentationDescriptor> addedElements = null;
        if (this.cacheEnabled) {
            addedElements = this.impactedRepDescriptors.put(key, dRepresentationDescriptors);
        }
        return addedElements;
    }

    public Collection<DRepresentationDescriptor> get(Object key) {
        Collection<DRepresentationDescriptor> values = null;
        if (this.cacheEnabled) {
            values = this.impactedRepDescriptors.get(key);
        }
        return values;
    }

    public Collection<DRepresentationDescriptor> remove(Object key) {
        Collection<DRepresentationDescriptor> removedElements = null;
        if (this.cacheEnabled) {
            removedElements = this.impactedRepDescriptors.remove(key);
        }
        return removedElements;
    }
}

