/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.drop.IInternalSourceToRepresentationDropChecker;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ComponentInternalSourceToRepresentationDropChecker
implements IInternalSourceToRepresentationDropChecker {
    @Override
    public CheckStatus canDragAndDrop(EObject elementToDrop, EObject newSemanticContainer) {
        return (CheckStatus)new ComponentDropOutsideRepresentationCheckerSwitch(newSemanticContainer).doSwitch(elementToDrop);
    }

    static class ComponentDropOutsideRepresentationCheckerSwitch
    extends UMLSwitch<CheckStatus> {
        private EObject newSemanticContainer;

        ComponentDropOutsideRepresentationCheckerSwitch(EObject target) {
            this.newSemanticContainer = target;
        }

        public CheckStatus caseComment(Comment comment) {
            CheckStatus result = this.newSemanticContainer instanceof Package ? CheckStatus.YES : CheckStatus.no("Comment can only be drag and drop on a Package");
            return result;
        }

        public CheckStatus caseComponent(Component component) {
            CheckStatus result = this.newSemanticContainer instanceof Component || this.newSemanticContainer instanceof Package ? CheckStatus.YES : CheckStatus.no("Component can only be drag and drop on a Component or Package");
            return result;
        }

        public CheckStatus caseConstraint(Constraint constraint) {
            CheckStatus result = this.newSemanticContainer instanceof Package ? CheckStatus.YES : CheckStatus.no("Constraint can only be drag and drop on a Package");
            return result;
        }

        public CheckStatus caseInterface(Interface interfaceElement) {
            CheckStatus result = this.newSemanticContainer instanceof Package ? CheckStatus.YES : CheckStatus.no("Interface can only be drag and drop on a Package");
            return result;
        }

        public CheckStatus caseOperation(Operation operation) {
            CheckStatus result = this.newSemanticContainer instanceof Interface ? CheckStatus.YES : CheckStatus.no("Operation can only be drag and drop on an Interface");
            return result;
        }

        public CheckStatus casePackage(Package pack) {
            CheckStatus result = this.newSemanticContainer instanceof Package ? CheckStatus.YES : CheckStatus.no("Package can only be drag and drop on a Package");
            return result;
        }

        public CheckStatus caseProperty(Property property) {
            CheckStatus result = property.eContainer() instanceof Classifier && property.getInterface() == null ? (this.newSemanticContainer instanceof Component || this.newSemanticContainer instanceof Property && ((Property)this.newSemanticContainer).getType() != null && !(this.newSemanticContainer instanceof Port) ? CheckStatus.YES : CheckStatus.no("Property cannot be dragged from a Classifier and dropped on a non-Component, non typed Property element")) : (property.getInterface() != null ? (this.newSemanticContainer instanceof Interface ? CheckStatus.YES : CheckStatus.no("Property cannot be dragged from an Interface and dropped on a non-Interface element")) : CheckStatus.no("Property can only be drag and drop on Component or Interface"));
            return result;
        }

        public CheckStatus caseReception(Reception reception) {
            CheckStatus result = this.newSemanticContainer instanceof Interface ? CheckStatus.YES : CheckStatus.no("Reception can ony be drag and drop on a Component");
            return result;
        }

        public CheckStatus defaultCase(EObject object) {
            return CheckStatus.no("DnD is not authorized.");
        }
    }
}

