/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.nattable.painter;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.papyrus.infra.editor.welcome.nattable.painter.LabelProviderImagePainter;
import org.eclipse.papyrus.infra.editor.welcome.nattable.painter.LabelProviderTextPainter;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class LabelPainter
extends CellPainterDecorator {
    public LabelPainter(CellEdgeEnum cellEdge) {
        this((ICellPainter)new LabelProviderTextPainter(), cellEdge, (ICellPainter)new LabelProviderImagePainter());
    }

    public LabelPainter(ICellPainter textPainter, CellEdgeEnum cellEdge) {
        this(textPainter, cellEdge, (ICellPainter)new LabelProviderImagePainter());
    }

    public LabelPainter(CellEdgeEnum cellEdge, ICellPainter imagePainter) {
        this((ICellPainter)new LabelProviderTextPainter(), cellEdge, imagePainter);
    }

    public LabelPainter(ICellPainter textPainter, CellEdgeEnum cellEdge, ICellPainter imagePainter) {
        super(textPainter, cellEdge, imagePainter);
    }

    public LabelPainter(ICellPainter textPainter, CellEdgeEnum cellEdge, ICellPainter imagePainter, boolean paintDecorationDependent) {
        super(textPainter, cellEdge, imagePainter, paintDecorationDependent);
    }

    public LabelPainter(ICellPainter textPainter, CellEdgeEnum cellEdge, int spacing, ICellPainter imagePainter) {
        super(textPainter, cellEdge, spacing, imagePainter);
    }

    public LabelPainter(ICellPainter textPainter, CellEdgeEnum cellEdge, int spacing, ICellPainter imagePainter, boolean paintDecorationDependent) {
        super(textPainter, cellEdge, spacing, imagePainter, paintDecorationDependent);
    }

    public LabelPainter(ICellPainter textPainter, CellEdgeEnum cellEdge, int spacing, ICellPainter imagePainter, boolean paintDecorationDependent, boolean paintBg) {
        super(textPainter, cellEdge, spacing, imagePainter, paintDecorationDependent, paintBg);
    }

    public Rectangle getTextBounds(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        Rectangle cellBounds = cell.getBounds();
        int imageWidth = this.getDecoratorCellPainter().getPreferredWidth(cell, gc, configRegistry);
        int imageHeight = this.getDecoratorCellPainter().getPreferredHeight(cell, gc, configRegistry);
        int preferredWidth = this.getBaseCellPainter().getPreferredWidth(cell, gc, configRegistry);
        int preferredHeight = this.getBaseCellPainter().getPreferredHeight(cell, gc, configRegistry);
        Rectangle result = null;
        switch (this.getCellEdge()) {
            case LEFT: {
                result = new Rectangle(cellBounds.x + imageWidth + this.getSpacing(), cellBounds.y, preferredWidth, cellBounds.height);
                break;
            }
            case RIGHT: {
                result = new Rectangle(cellBounds.x, cellBounds.y, preferredWidth, cellBounds.height);
                break;
            }
            case TOP: {
                result = new Rectangle(cellBounds.x, cellBounds.y + imageHeight + this.getSpacing(), cellBounds.width, preferredHeight);
                break;
            }
            case BOTTOM: {
                result = new Rectangle(cellBounds.x, cellBounds.y, cellBounds.width, preferredHeight);
                break;
            }
            case TOP_LEFT: {
                result = new Rectangle(cellBounds.x + imageWidth + this.getSpacing(), cellBounds.y + imageHeight + this.getSpacing(), preferredWidth, preferredHeight);
                break;
            }
            case TOP_RIGHT: {
                result = new Rectangle(cellBounds.x, cellBounds.y + imageHeight + this.getSpacing(), preferredWidth, preferredHeight);
                break;
            }
            case BOTTOM_LEFT: {
                result = new Rectangle(cellBounds.x + imageWidth + this.getSpacing(), cellBounds.y, preferredWidth, preferredHeight);
                break;
            }
            case BOTTOM_RIGHT: {
                result = new Rectangle(cellBounds.x, cellBounds.y, preferredWidth, preferredHeight);
                break;
            }
        }
        if (result != null) {
            result = result.intersection(cellBounds);
        }
        return result;
    }
}

