/**
 * Copyright (c) 2023 CEA LIST.
 *
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 *
 *  SPDX-License-Identifier: EPL-2.0
 *
 *  Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 *
 * @generated
 */
public class MarkupUMLDocumentStructureTemplateFactoryImpl extends EFactoryImpl implements MarkupUMLDocumentStructureTemplateFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public static MarkupUMLDocumentStructureTemplateFactory init() {
		try {
			MarkupUMLDocumentStructureTemplateFactory theMarkupUMLDocumentStructureTemplateFactory = (MarkupUMLDocumentStructureTemplateFactory) EPackage.Registry.INSTANCE.getEFactory(MarkupUMLDocumentStructureTemplatePackage.eNS_URI);
			if (theMarkupUMLDocumentStructureTemplateFactory != null) {
				return theMarkupUMLDocumentStructureTemplateFactory;
			}
		} catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new MarkupUMLDocumentStructureTemplateFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public MarkupUMLDocumentStructureTemplateFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
		case MarkupUMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE:
			return createStereotypePropertyAttributeInMarkupToFile();
		case MarkupUMLDocumentStructureTemplatePackage.COMMENT_IN_MARKUP_TO_FILE:
			return createCommentInMarkupToFile();
		default:
			throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier"); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public StereotypePropertyAttributeInMarkupToFile createStereotypePropertyAttributeInMarkupToFile() {
		StereotypePropertyAttributeInMarkupToFileImpl stereotypePropertyAttributeInMarkupToFile = new StereotypePropertyAttributeInMarkupToFileImpl();
		return stereotypePropertyAttributeInMarkupToFile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public CommentInMarkupToFile createCommentInMarkupToFile() {
		CommentInMarkupToFileImpl commentInMarkupToFile = new CommentInMarkupToFileImpl();
		return commentInMarkupToFile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public MarkupUMLDocumentStructureTemplatePackage getMarkupUMLDocumentStructureTemplatePackage() {
		return (MarkupUMLDocumentStructureTemplatePackage) getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static MarkupUMLDocumentStructureTemplatePackage getPackage() {
		return MarkupUMLDocumentStructureTemplatePackage.eINSTANCE;
	}

} // MarkupUMLDocumentStructureTemplateFactoryImpl
