/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib.model;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.IntermediateClassFactory;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QVTStackTraceElement;
import org.eclipse.m2m.internal.qvt.oml.stdlib.model.ExceptionInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.model.StatusInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.model.StdlibPackage;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictionaryType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeOCLFactory;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListType;
import org.eclipse.m2m.qvt.oml.util.Dictionary;
import org.eclipse.m2m.qvt.oml.util.MutableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdlibFactory {
    private StdlibPackage fStdlibPackage;

    public StdlibFactory(StdlibPackage stdlibPackage) {
        if (stdlibPackage == null) {
            throw new IllegalArgumentException("null stdlib package");
        }
        this.fStdlibPackage = stdlibPackage;
    }

    public DictionaryType createDictionary(EClassifier keyType, EClassifier elementType) {
        DictionaryType dictType = ImperativeOCLFactory.eINSTANCE.createDictionaryType();
        dictType.setKeyType(keyType);
        dictType.setElementType((Object)elementType);
        dictType.setName(StdlibFactory.getTypeName(dictType));
        dictType.setInstanceClass(Dictionary.class);
        return dictType;
    }

    public ListType createList(EClassifier elementType) {
        ListType listType = ImperativeOCLFactory.eINSTANCE.createListType();
        listType.setElementType((Object)elementType);
        listType.setName(StdlibFactory.getTypeName(listType));
        listType.setInstanceClass(MutableList.class);
        return listType;
    }

    public StatusInstance createSuccess() {
        Status status = new Status(true, null);
        status.eSetClass(this.fStdlibPackage.getStatusClass());
        return status;
    }

    public StatusInstance createFailure(ExceptionInstance exception) {
        Status status = new Status(false, exception);
        status.eSetClass(this.fStdlibPackage.getStatusClass());
        return status;
    }

    public ExceptionInstance createException(EClass exceptionClass, String argument, List<QVTStackTraceElement> stackElements) {
        IntermediateClassFactory.ExceptionClassInstance exception = new IntermediateClassFactory.ExceptionClassInstance(exceptionClass);
        exception.setArgument(argument);
        exception.setStackElements(Collections.unmodifiableList(stackElements));
        return exception;
    }

    private static String getTypeName(ListType type) {
        StringBuffer nameBuf = new StringBuffer();
        nameBuf.append("List");
        nameBuf.append('(');
        EClassifier elementType = (EClassifier)type.getElementType();
        String elementTypeName = elementType != null ? elementType.getName() : "";
        nameBuf.append(elementTypeName);
        nameBuf.append(')');
        return nameBuf.toString();
    }

    private static String getTypeName(DictionaryType dictionaryType) {
        StringBuilder nameBuf = new StringBuilder();
        nameBuf.append("Dictionary");
        nameBuf.append('(');
        EClassifier keyType = dictionaryType.getKeyType();
        EClassifier elementType = (EClassifier)dictionaryType.getElementType();
        if (keyType != null) {
            nameBuf.append(keyType.getName());
        } else {
            nameBuf.append("null");
        }
        nameBuf.append(',').append(' ');
        if (elementType != null) {
            nameBuf.append(elementType.getName());
        } else {
            nameBuf.append("null");
        }
        nameBuf.append(')');
        return nameBuf.toString();
    }

    private static class Status
    extends EObjectImpl
    implements StatusInstance {
        private boolean fIsSuccess;
        private ExceptionInstance fException;

        private Status(boolean isSuccess, ExceptionInstance exception) {
            this.fIsSuccess = isSuccess;
            this.fException = exception;
        }

        public boolean succeeded() {
            return this.fIsSuccess;
        }

        public boolean failed() {
            return !this.succeeded();
        }

        public ExceptionInstance raisedException() {
            return this.fException;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.fIsSuccess ? "SUCCESS" : "FAILED");
            if (this.fException != null) {
                buf.append(" raised: (").append(this.fException).append(')');
            }
            return buf.toString();
        }
    }
}

