/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.stream.Stream;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.linuxtools.docker.core.AbstractRegistry;
import org.eclipse.linuxtools.docker.core.IRegistryAccount;
import org.eclipse.linuxtools.internal.docker.core.RegistryAccountInfo;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RegistryAccountDialog
extends Dialog {
    private String serverAddress;
    private String username;
    private String email;
    private char[] password;
    private String title;
    private String explanation = WizardMessages.getString("RegistryAccountDialog.add.edit.explanation");

    public RegistryAccountDialog(Shell parentShell, String title) {
        super(parentShell);
        this.title = title;
    }

    public RegistryAccountDialog(Shell parentShell, String title, String defaultServerAddress, String explanation) {
        super(parentShell);
        this.title = title;
        this.serverAddress = defaultServerAddress;
        this.explanation = explanation;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Point getInitialSize() {
        return new Point(350, super.getInitialSize().y);
    }

    protected Control createDialogArea(Composite parent) {
        int COLUMNS = 2;
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo(container);
        Label explanationLabel = new Label(container, 0);
        explanationLabel.setText(this.explanation);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(false, false).applyTo((Control)explanationLabel);
        Label serverLabel = new Label(container, 0);
        serverLabel.setText(WizardMessages.getString("RegistryAccountDialog.server.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)serverLabel);
        Text serverText = new Text(container, 2048);
        serverText.setToolTipText(WizardMessages.getString("RegistryAccountDialog.server.desc"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)serverText);
        if (this.serverAddress != null) {
            serverText.setText(this.serverAddress);
        }
        serverText.addModifyListener(e -> {
            this.serverAddress = serverText.getText();
            this.validate();
        });
        Label usernameLabel = new Label(container, 0);
        usernameLabel.setText(WizardMessages.getString("RegistryAccountDialog.username.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)usernameLabel);
        Text usernameText = new Text(container, 2048);
        usernameText.setToolTipText(WizardMessages.getString("RegistryAccountDialog.username.desc"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)usernameText);
        if (this.username != null) {
            usernameText.setText(this.username);
        }
        usernameText.addModifyListener(e -> {
            this.username = usernameText.getText();
            this.validate();
        });
        Label emailLabel = new Label(container, 0);
        emailLabel.setText(WizardMessages.getString("RegistryAccountDialog.email.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)emailLabel);
        Text emailText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)emailText);
        if (this.email != null) {
            emailText.setText(this.email);
        } else {
            this.email = "";
        }
        emailText.addModifyListener(e -> {
            this.email = emailText.getText();
        });
        Label passwordLabel = new Label(container, 0);
        passwordLabel.setText(WizardMessages.getString("RegistryAccountDialog.password.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)passwordLabel);
        Text passwordText = new Text(container, 2048);
        passwordText.setEchoChar('*');
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)passwordText);
        if (this.password != null) {
            passwordText.setText(new String(this.password));
        }
        passwordText.addModifyListener(e -> {
            this.password = passwordText.getText().toCharArray();
            this.validate();
        });
        return container;
    }

    private void validate() {
        if (this.serverAddress != null && !this.serverAddress.isEmpty()) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    public void setInputData(IRegistryAccount info) {
        this.serverAddress = info.getServerAddress();
        this.username = info.getUsername();
        this.email = info.getEmail();
        this.password = info.getPassword();
    }

    public IRegistryAccount getSignonInformation() {
        boolean dockerHubRegistryAlias = Stream.of(AbstractRegistry.DOCKERHUB_REGISTRY_ALIASES).anyMatch(alias -> this.serverAddress.contains((CharSequence)alias));
        return new RegistryAccountInfo(this.serverAddress, this.username, this.email, this.password, dockerHubRegistryAlias);
    }
}

