/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.abstractexec.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.abstractexec.behavior.Activator;
import org.eclipse.etrice.abstractexec.behavior.HandledMessage;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.InSemanticsRule;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.ProtocolSemantics;
import org.eclipse.etrice.core.fsm.fSM.SemanticsRule;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;

public class ActiveRules {
    private HashMap<AbstractInterfaceItem, List<SemanticsRule>> rules;
    private static boolean traceRules = false;
    private static int traceLevel = 0;
    private FSMNameProvider fsmNameProvider = new FSMNameProvider();
    private EAttribute nameAttribute = null;
    private static final int TRACE_DETAILS = 2;

    static {
        if (Activator.getDefault().isDebugging()) {
            String value = Platform.getDebugOption((String)"org.eclipse.etrice.abstractexec.behavior/trace/rules");
            if (value != null && value.equalsIgnoreCase(Boolean.toString(true))) {
                traceRules = true;
            }
            if ((value = Platform.getDebugOption((String)"org.eclipse.etrice.abstractexec.behavior/trace/rules/level")) != null) {
                traceLevel = Integer.parseInt(value);
            }
        }
    }

    public ActiveRules() {
        this(new HashMap<AbstractInterfaceItem, List<SemanticsRule>>());
    }

    private ActiveRules(HashMap<AbstractInterfaceItem, List<SemanticsRule>> r) {
        List<SemanticsRule> ruleList;
        this.rules = r;
        if (!this.rules.isEmpty() && !(ruleList = this.rules.values().iterator().next()).isEmpty()) {
            SemanticsRule rule = ruleList.get(0);
            for (EAttribute att : rule.getMsg().eClass().getEAllAttributes()) {
                if (!att.getName().equals("name")) continue;
                this.nameAttribute = att;
                break;
            }
        }
    }

    public Set<AbstractInterfaceItem> getPortList() {
        return this.rules.keySet();
    }

    public List<SemanticsRule> getRulesForPort(AbstractInterfaceItem port) {
        return this.rules.get(port);
    }

    public List<HandledMessage> consumeMessages(List<HandledMessage> msgList) {
        ArrayList<HandledMessage> wrongMsgList = new ArrayList<HandledMessage>();
        for (HandledMessage msg : msgList) {
            List<SemanticsRule> localRules = this.rules.get(msg.getIfitem());
            if (localRules == null) continue;
            SemanticsRule match = null;
            for (SemanticsRule rule : localRules) {
                if (rule.getMsg() != msg.getMsg()) continue;
                match = rule;
                break;
            }
            if (match != null) {
                if (traceRules && traceLevel >= 2) {
                    System.out.println("  found match for " + this.fsmNameProvider.getMessageName(msg.getMsg()));
                }
                localRules.clear();
                if (match.getFollowUps().isEmpty()) {
                    ProtocolSemantics semantics = msg.getIfitem().getSemantics();
                    localRules.addAll((Collection<SemanticsRule>)semantics.getRules());
                    continue;
                }
                localRules.addAll((Collection<SemanticsRule>)match.getFollowUps());
                continue;
            }
            StringBuilder sb = new StringBuilder("Valid messages at this point:");
            for (SemanticsRule rule : localRules) {
                String name = rule.getMsg().toString();
                if (this.nameAttribute != null) {
                    name = (String)rule.getMsg().eGet((EStructuralFeature)this.nameAttribute);
                }
                sb.append("\n" + name);
            }
            msg.setReason(sb.toString());
            wrongMsgList.add(msg);
        }
        return wrongMsgList;
    }

    public boolean merge(ActiveRules ar) {
        boolean added_at_least_one = false;
        for (Map.Entry<AbstractInterfaceItem, List<SemanticsRule>> entry : ar.rules.entrySet()) {
            for (SemanticsRule rule : entry.getValue()) {
                AbstractInterfaceItem ifitem = entry.getKey();
                if (this.rules.containsKey(ifitem)) {
                    if (this.rules.get(ifitem).contains(rule)) continue;
                    this.rules.get(ifitem).add(rule);
                    added_at_least_one = true;
                    continue;
                }
                ArrayList<SemanticsRule> tempList = new ArrayList<SemanticsRule>();
                tempList.add(rule);
                this.rules.put(ifitem, tempList);
                added_at_least_one = true;
            }
        }
        if (traceRules && traceLevel >= 2) {
            System.out.println("  merge changed rules");
        }
        return added_at_least_one;
    }

    public ActiveRules createCopy() {
        HashMap<AbstractInterfaceItem, List<SemanticsRule>> newRules = new HashMap<AbstractInterfaceItem, List<SemanticsRule>>();
        for (AbstractInterfaceItem ifitem : this.rules.keySet()) {
            newRules.put(ifitem, new ArrayList(this.rules.get(ifitem)));
        }
        return new ActiveRules(newRules);
    }

    public void buildInitLocalRules(ModelComponent mc) {
        EList portList = mc.getAllAbstractInterfaceItems();
        for (AbstractInterfaceItem ifitem : portList) {
            if (ifitem.getSemantics() == null) continue;
            this.rules.put(ifitem, new ArrayList(ifitem.getSemantics().getRules()));
        }
    }

    public void print() {
        for (AbstractInterfaceItem port : this.rules.keySet()) {
            System.out.println("      Rules for Port " + port.getName() + ":");
            for (SemanticsRule rule : this.rules.get(port)) {
                this.printRule(rule, "        ");
            }
        }
    }

    public void printRule(SemanticsRule rule, String indent) {
        if (rule instanceof InSemanticsRule) {
            System.out.println(indent + "in: " + this.fsmNameProvider.getMessageName(rule.getMsg()));
        } else {
            System.out.println(indent + "out: " + this.fsmNameProvider.getMessageName(rule.getMsg()));
        }
        for (SemanticsRule sr : rule.getFollowUps()) {
            this.printRule(sr, indent + "  ");
        }
    }
}

