//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2025 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

package org.eclipse.escet.cif.bdd.settings;

import org.eclipse.escet.cif.bdd.spec.CifBddEdge;

/**
 * This enumeration lists certain BDD predicates that are freed by the CIF/BDD library once they are no longer needed,
 * for which there are specific cases where it may be needed or convenient to keep them a bit longer. Each enumeration
 * constant indicates a particular BDD or set of BDDs that is normally freed in specific places, and for which it is
 * possible to forego freeing it/them.
 *
 * <p>
 * Freeing the BDDs once they are no longer needed can help to reduce memory usage of the BDDs, while keeping them alive
 * allows them to still be used afterwards.
 * </p>
 */
public enum CifBddFree {
    /** Free {@link CifBddEdge#update} in {@link CifBddEdge#initApply}. */
    EDGE_UPDATE,

    /** Free {@link CifBddEdge#updateGuard} in {@link CifBddEdge#cleanupApply}. */
    EDGE_UPDATE_GUARD,

    /** Free {@link CifBddEdge#updateGuardSupport} in {@link CifBddEdge#cleanupApply}. */
    EDGE_UPDATE_GUARD_SUPPORT,
}
