/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.internal.ui;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.text.quicksearch.internal.core.preferences.QuickSearchPreferences;
import org.eclipse.text.quicksearch.internal.ui.Messages;
import org.eclipse.text.quicksearch.internal.ui.QuickSearchActivator;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class QuickSearchPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String[] prefsKeys = new String[]{"ignored.extensions", "ignored.prefixes", "ignored.names"};
    private static final String[] fieldLabels = new String[]{Messages.QuickSearchPreferencesPage_Ignored_Extensions, Messages.QuickSearchPreferencesPage_Ignored_Prefixes, Messages.QuickSearchPreferencesPage_Ignored_Names};
    private static final String[] toolTips = new String[]{Messages.QuickSearchPreferencesPage_Tooltip_Extensions, Messages.QuickSearchPreferencesPage_Tooltip_Prefixes, Messages.QuickSearchPreferencesPage_Tooltip_Names};

    public QuickSearchPreferencesPage() {
        super(1);
        this.setPreferenceStore(QuickSearchActivator.getDefault().getPreferenceStore());
        QuickSearchPreferences.initializeDefaults();
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        IntegerFieldEditor fieldMaxLineLen = new IntegerFieldEditor("LineReader.MAX_LINE_LEN", Messages.QuickSearchPreferencesPage_MaxLineLength, this.getFieldEditorParent());
        this.addField((FieldEditor)fieldMaxLineLen);
        ControlDecoration maxLengthFieldDecoration = new ControlDecoration((Control)fieldMaxLineLen.getTextControl(this.getFieldEditorParent()), 16512);
        maxLengthFieldDecoration.setDescriptionText(Messages.QuickSearchPreferencesPage_Tooltip_MaxLineLength);
        maxLengthFieldDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        IntegerFieldEditor fieldMaxResults = new IntegerFieldEditor("QuickTextSearcher.MAX_RESULTS", Messages.QuickSearchPreferencesPage_MaxResults, this.getFieldEditorParent());
        this.addField((FieldEditor)fieldMaxResults);
        ControlDecoration maxResultsFieldDecoration = new ControlDecoration((Control)fieldMaxResults.getTextControl(this.getFieldEditorParent()), 16512);
        maxResultsFieldDecoration.setDescriptionText(Messages.QuickSearchPreferencesPage_Tooltip_MaxResults);
        maxResultsFieldDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        int i = 0;
        while (i < fieldLabels.length) {
            final String tooltip = toolTips[i];
            StringFieldEditor field = new StringFieldEditor(prefsKeys[i], fieldLabels[i], StringFieldEditor.UNLIMITED, 5, 1, this.getFieldEditorParent()){

                protected Text createTextWidget(Composite parent) {
                    Text w = super.createTextWidget(parent);
                    ControlDecoration fieldDecoration = new ControlDecoration((Control)w, 16512);
                    fieldDecoration.setDescriptionText(tooltip);
                    fieldDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
                    return w;
                }

                protected void doFillIntoGrid(Composite parent, int numColumns) {
                    super.doFillIntoGrid(parent, numColumns);
                    Text text = this.getTextControl();
                    GridData layout = (GridData)text.getLayoutData();
                    layout.widthHint = 400;
                    layout.minimumWidth = 100;
                }
            };
            this.addField((FieldEditor)field);
            ++i;
        }
    }
}

