/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ui.properties.sections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataContentProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.transfer.TransferTreeListViewer;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaTypesFolder;
import org.polarsys.capella.vp.requirements.ui.properties.widgets.FixedPreferredSizeComposite;
import org.polarsys.kitalpha.emde.model.ElementExtension;
import org.polarsys.kitalpha.vp.requirements.Requirements.AbstractType;
import org.polarsys.kitalpha.vp.requirements.Requirements.RelationType;

public abstract class AbstractAllocationSection
extends AbstractSection {
    public static final int DEFAULT_EXPAND_LEVEL = 4;
    public static final int DEFAULT_TREE_VIEWER_STYLE = 2818;
    public static final int TRANSFER_TREE_STYLE = 124;
    protected Group relationDirectionGroup;
    protected ComboViewer relationTypeComboViewer;
    protected TransferTreeListViewer transferTreeViewer;
    protected EObject capellaElement;

    protected void createRelationConfig(Group grp) {
        this.relationDirectionGroup = this.getWidgetFactory().createGroup((Composite)grp, "Relation direction:");
        this.relationDirectionGroup.setLayout((Layout)new GridLayout(2, true));
        Button incoming = this.getWidgetFactory().createButton((Composite)this.relationDirectionGroup, "In-link", 16);
        incoming.setData((Object)RelationDirectionKind.IN);
        Button outgoing = this.getWidgetFactory().createButton((Composite)this.relationDirectionGroup, "Out-link", 16);
        outgoing.setData((Object)RelationDirectionKind.OUT);
        outgoing.setSelection(true);
        Group relationTypeGrp = this.getWidgetFactory().createGroup((Composite)grp, "Relation type: ");
        relationTypeGrp.setLayout((Layout)new GridLayout());
        relationTypeGrp.setLayoutData((Object)new GridData(768));
        CCombo combo = this.getWidgetFactory().createCCombo((Composite)relationTypeGrp, 2056);
        this.relationTypeComboViewer = new ComboViewer(combo);
        this.relationTypeComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((RelationType)element).getReqIFLongName();
            }
        });
    }

    protected void addRequirementsRelationTypes(EObject capellaElement) {
        CCombo combo = this.relationTypeComboViewer.getCCombo();
        combo.removeAll();
        BlockArchitecture archi = BlockArchitectureExt.getRootBlockArchitecture((EObject)capellaElement);
        if (archi != null) {
            for (ElementExtension extension : archi.getOwnedExtensions()) {
                if (!(extension instanceof CapellaTypesFolder)) continue;
                CapellaTypesFolder typesfolder = (CapellaTypesFolder)extension;
                for (AbstractType ownedType : typesfolder.getOwnedTypes()) {
                    if (!(ownedType instanceof RelationType)) continue;
                    this.relationTypeComboViewer.add((Object)ownedType);
                }
            }
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
            combo.redraw();
        }
    }

    protected RelationDirectionKind getRelationDirection() {
        Control[] controlArray = this.relationDirectionGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control button = controlArray[n2];
            if (((Button)button).getSelection()) {
                return (RelationDirectionKind)((Object)button.getData());
            }
            ++n2;
        }
        return null;
    }

    protected RelationType getRelationType() {
        Object object = this.relationTypeComboViewer.getElementAt(this.relationTypeComboViewer.getCCombo().getSelectionIndex());
        if (object instanceof RelationType) {
            return (RelationType)object;
        }
        return null;
    }

    protected void createTransferTreeListViewer(Composite parent) {
        FixedPreferredSizeComposite fixedPreferredSizeComposite = new FixedPreferredSizeComposite(parent, 0);
        fixedPreferredSizeComposite.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.transferTreeViewer = new TransferTreeListViewer(fixedPreferredSizeComposite, 124, 2818, 2818, 4, 4){

            protected boolean doHandleAddAllButton() {
                AbstractAllocationSection.this.handleAddAllButton();
                return super.doHandleAddAllButton();
            }

            protected boolean doHandleRemoveAllButton() {
                AbstractAllocationSection.this.handleRemoveAllButton();
                return super.doHandleRemoveAllButton();
            }

            protected boolean doHandleAddSelectedButton() {
                AbstractAllocationSection.this.handleAddSelectedButton();
                return super.doHandleAddSelectedButton();
            }

            protected boolean doHandleRemoveSelectedButton() {
                AbstractAllocationSection.this.handleRemoveSelectedButton();
                return super.doHandleRemoveSelectedButton();
            }
        };
        this.transferTreeViewer.setLeftContentProvider((IContentProvider)new DataContentProvider());
        this.transferTreeViewer.setRightContentProvider((IContentProvider)new DataContentProvider());
        fixedPreferredSizeComposite.setPreferredSize(this.transferTreeViewer.getControl().computeSize(-1, -1));
    }

    protected void handleAddAllButton() {
        this.addAllocations(this.transferTreeViewer.getLeftInput().getValidElements());
    }

    protected void handleRemoveAllButton() {
        this.removeAllocations(this.transferTreeViewer.getRightInput().getValidElements());
    }

    protected void handleAddSelectedButton() {
        this.addAllocations(((IStructuredSelection)this.transferTreeViewer.getLeftViewer().getSelection()).toList());
    }

    protected void handleRemoveSelectedButton() {
        this.removeAllocations(((IStructuredSelection)this.transferTreeViewer.getRightViewer().getSelection()).toList());
    }

    protected void addAllocations(Collection<Object> elts) {
    }

    protected void removeAllocations(Collection<Object> elts) {
    }

    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> abstractSemanticFields = new ArrayList<AbstractSemanticField>();
        return abstractSemanticFields;
    }

    static enum RelationDirectionKind {
        IN,
        OUT;

    }
}

